        document.addEventListener('DOMContentLoaded', function() {
            const MAX = 4;
            const KEY = 'compareList';
            const getList = () => JSON.parse(localStorage.getItem(KEY) || '[]');
            const saveList = (arr) => localStorage.setItem(KEY, JSON.stringify(arr));

            const tray = document.getElementById('compare-tray');
            const itemsWrap = document.getElementById('compare-items');
            const countEl = document.getElementById('compare-count');
            const warnEl = document.getElementById('compare-warning');

            function updateTrayVisibility() {
                const hasItems = getList().length > 0;
                tray.classList.toggle('is-visible', hasItems);
            }

            function render() {
                const list = getList();
                itemsWrap.innerHTML = '';
                list.forEach(p => {
                    const card = document.createElement('div');
                    card.className = 'compare-card';
                    card.innerHTML = `
        <button class="remove-item" data-id="${p.id}" aria-label="إزالة">×</button>
        <img src="${p.image}" alt="${p.name}">
        <div class="title" title="${p.name}">${p.name}</div>
      `;
                    itemsWrap.appendChild(card);
                });
                if (countEl) countEl.textContent = `(${list.length}/${MAX})`;
                if (warnEl) warnEl.classList.toggle('d-none', list.length <= MAX);
                updateTrayVisibility();
            }

            function addToCompare(product) {
                const list = getList();
                if (list.find(x => String(x.id) === String(product.id))) return;
                if (list.length >= MAX) {
                    warnEl?.classList.remove('d-none');
                    return;
                }
                list.push(product);
                saveList(list);
                render();
            }

            function removeFromCompare(id) {
                const list = getList().filter(x => String(x.id) !== String(id));
                saveList(list);
                render();
            }

            // أحداث
            document.addEventListener('click', function(e) {
                // زر أضف للمقارنة في بطاقات المنتجات
                const addBtn = e.target.closest('.btn-compare');
                if (addBtn) {
                    const {
                        id,
                        name,
                        image
                    } = addBtn.dataset;
                    addToCompare({
                        id,
                        name,
                        image
                    }); // image جاهز كرابط كامل أو اسم ملف مجمّع مسبقًا
                    return;
                }

                // × إزالة
                const rm = e.target.closest('.remove-item');
                if (rm) {
                    removeFromCompare(rm.dataset.id);
                    return;
                }

                // مسح الكل
                if (e.target.id === 'clear-compare' || e.target.closest('#clear-compare')) {
                    saveList([]);
                    render();
                    return;
                }

                // فتح صفحة المقارنة
                // فتح صفحة المقارنة (POST للراوت)
                if (e.target.id === 'open-compare-page' || e.target.closest('#open-compare-page')) {
                    const ids = getList().map(x => x.id);
                    if (!ids.length) return;

                    // أرسلها كنص مفصول بفواصل أو كمصفوفة (الاثنان مدعومان في الكنترولر)
                    const form = document.getElementById('compare-form');
                    const input = document.getElementById('compare-ids');
                    input.value = ids.join(','); // أو: input.value = JSON.stringify(ids);
                    form.submit();
                    return;
                }


                // إخفاء الشريط (لا يمسح البيانات)
                if (e.target.id === 'hide-tray' || e.target.closest('#hide-tray')) {
                    tray.classList.remove('is-visible');
                    return;
                }
            });

            // رسم أولي
            render();

            // كشف الدوال لو احتجتها خارجيًا
            window.addToCompare = addToCompare;
            window.removeFromCompare = removeFromCompare;
        });
    