<?php $__env->startSection('title', __('lang.products')); ?>

<?php $__env->startSection('content'); ?>


    <!-- Product Quick View Modal Start -->
    <div class="modal fade quick-view-product" id="quick-view-modal" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                        <i class="far fa-times"></i>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="single-product-thumb">
                        <div class="row">
                            <div class="col-lg-7 mb--40">
                                <div class="row">
                                    <div class="col-lg-10 order-lg-2">
                                        <div
                                            class="single-product-thumbnail product-large-thumbnail axil-product thumbnail-badge zoom-gallery">
                                            <div class="thumbnail">
                                                <img id="product-image"
                                                     src="<?php echo e(asset('web/assets/images/product/product-big-01.png')); ?>"
                                                     alt="Product Images">
                                                <div class="label-block label-right">
                                                    <div class="product-badget" id="dicount_text">0 % OFF</div>
                                                </div>
                                                <div class="product-quick-view position-view">
                                                    <a id="popup_image"
                                                       href="<?php echo e(asset('web/assets/images/product/product-big-01.png')); ?>"
                                                       class="popup-zoom">
                                                        <i class="far fa-search-plus"></i>
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-lg-2 order-lg-1" id="sadsads">
                                        <div class="product-small-thumb small-thumb-wrapper" id="show_images">

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-5 mb--40">
                                <div class="single-product-content">
                                    <div class="inner">
                                        <div class="product-rating">
                                            <div class="star-rating" id="div_reviews">
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                                <i class="fal fa-star" id="box_reviews"></i>
                                            </div>
                                            <div class="review-link">
                                                <a>(<span id="count_reviews"></span> <?php echo e(__('lang.customer_reviews')); ?>)</a>
                                            </div>
                                        </div>
                                        <h3 id="product-title" class="product-title">Serif Coffee Table</h3>
                                        <span id="product-price" class="price-amount">
                                            $255.00
                                        </span>
                                        
                                        
                                        
                                        
                                        
                                        <div class="description row" id="show_descriptions">
                                            <div class="d-flex align-items-center col-sm-12" id="show_description"
                                                 style="margin-bottom: 3px">
                                                <h6 class="mb-0">
                                                    title_en
                                                </h6>
                                                <div class="box-container d-flex flex-wrap mx-3">
                                                <span class="description-text">
                                                    option_ar
                                                </span>
                                                    <span class="description-text">
                                                   other_option_en
                                                </span>

                                                </div>
                                            </div>
                                        </div>

                                        <div class="product-variation">
                                            <h6 class="title"><?php echo e(__('lang.Colors')); ?>:</h6>
                                            <!-- mona color radio button -->
                                            <div class="box-color d-flex" id="products_colors">
                                                <div class="container-color-box d-flex mb-4" id="product_colors">
                                                    <input name="colorcolor" class="color" type="radio"
                                                           id="color-#000000"
                                                           value="#000000" data-color="#000000"/>
                                                    <label for="color-#000000"></label>
                                                </div>
                                            </div>
                                            <!-- end -->
                                        </div>

                                        <!-- Start Product Action Wrapper  -->
                                        <div class="product-action-wrapper d-flex-center">
                                            <!-- Start Product Action  -->
                                            <ul class="product-action d-flex-center mb--0">
                                                <div class="pro-qty mr--20">
                                                    <span class="dec qtybtn">-</span>
                                                    <input type="text" name="quantity" id="out_quantity_out" value="1">
                                                    <span class="inc qtybtn">+</span>
                                                </div>
                                                <li class="add-to-cart">
                                                    <form action="<?php echo e(route('cart.store')); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>

                                                        <input type="hidden" name="color" id="colorForm_colorForm">

                                                        <input type="hidden" name="quantity" id="in_quantity_in">

                                                        <input type="hidden" name="product_id" id="product_iddd">

                                                        <button type="submit" id="cart-btn" class="add-product">
                                                            <?php echo e(__('lang.add-cart')); ?>

                                                        </button>
                                                    </form>
                                                </li>
                                                <li class="wishlist" id="add_favadd_fav" style="cursor: pointer">
                                                    <a>
                                                        <button class="axil-btn wishlist-btn">
                                                            <i class="far fa-heart red-color " id="heart"></i>
                                                        </button>
                                                    </a>
                                                </li>
                                            </ul>
                                            <!-- End Product Action  -->

                                        </div>
                                        <!-- End Product Action Wrapper  -->
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Product Quick View Modal End -->

    <?php if($single_product): ?>
        <!-- Start Breadcrumb Area  -->
        <div class="d-none d-md-block axil-breadcrumb-area">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6 col-md-8">
                        <div class="inner">
                            <ul class="axil-breadcrumb">
                                <li class="axil-breadcrumb-item"><a href="<?php echo e(url('/')); ?>"><?php echo e(__('lang.Home')); ?></a></li>
                                <li class="separator"></li>
                                <?php if(request()->get('type') == 'new'): ?>
                                    <li class="axil-breadcrumb-item active" aria-current="page"><?php echo e(__('lang.Products2')); ?></li>
                                <?php elseif(request()->get('type') == 'sold'): ?>
                                    <li class="axil-breadcrumb-item active" aria-current="page"><?php echo e(__('lang.Products3')); ?></li>
                                <?php else: ?>
                                    <li class="axil-breadcrumb-item active" aria-current="page"><?php echo e(__('lang.Products1')); ?></li>
                                <?php endif; ?>
                            </ul>
                            <h1 class="title"><?php echo e(__('lang.explore-product')); ?></h1>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-4">
                        <div class="inner d-flex justify-content-end">
                            <div class="bradcrumb-thumb">
                                <div class="content-img">
                                    <img data-sal-delay="200" data-sal-duration="500" src="<?php echo e(Request::root() . '/dashboard/images/' . $single_product->image); ?>" alt="Image" style="height: 90%; width: 90%">
                                </div>
                                <!-- <br> -->
                                <a style="font-size: 14px;" href="<?php echo e(route('product.show' , $single_product->id )); ?>">
                                    <?php if( app()->getLocale() == 'en' ): ?>
                                        <?php echo e($single_product->name_en); ?>

                                    <?php elseif( app()->getLocale() == 'ar' ): ?>
                                        <?php echo e($single_product->name_ar); ?>

                                    <?php endif; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- End Breadcrumb Area  -->
    <?php endif; ?>
    <!-- Start Shop Area  -->
    <div class="axil-shop-area axil-section-gap">
        <div class="container">
            <div class="row row--15">
                <?php $__currentLoopData = $products_s; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-4 col-sm-6">
                        <div class="axil-product product-style-one has-color-pick mt--40">
                            <div class="thumbnail">
                                <a href="<?php echo e(route('product.show', ['id' => $product->id])); ?>">
                                    <img src="<?php echo e(Request::root() . '/dashboard/images/' . $product->image); ?>" alt="Product Images">
                                </a>
                                <div class="label-block label-right">
                                    <div class="product-badget"><?php echo e($product->discount); ?>% OFF</div>
                                </div>
                                <div class="product-hover-action">
                                    <ul class="cart-action">
                                        <li class="quickview">
                                            <a href="#" data-bs-toggle="modal" class="eye-modal"
                                               data-id="<?php echo e($product->id); ?>" data-bs-target="#quick-view-modal">
                                                <i class="far fa-eye"></i>
                                            </a>
                                        </li>
                                        <li class="select-option">
                                            <button>
                                                <a href="<?php echo e(route('product.show' , $product->id )); ?>"
                                                   style="color: white">
                                                    <?php echo e(__('lang.Select_Option')); ?>

                                                </a>
                                            </button>
                                        </li>
                                        <li class="wishlist" id="add_fav" style="cursor: pointer"
                                            data-id="<?php echo e($product->id); ?>">
                                            <a>
                                                <?php $__empty_1 = true; $__currentLoopData = $product->favorite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $favorites): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                    <?php if(\Illuminate\Support\Facades\Auth::user()): ?>
                                                        <?php if($favorites->user_id == \Illuminate\Support\Facades\Auth::user()->id): ?>
                                                            <i class="far fa-heart red-color" id="heart"></i>
                                                            <?php break; ?>
                                                        <?php else: ?>
                                                            <i class="far fa-heart" id="heart"></i>
                                                            <?php break; ?>
                                                        <?php endif; ?>
                                                        <?php break; ?>
                                                    <?php else: ?>
                                                        <i class="far fa-heart" id="heart"></i>
                                                        <?php break; ?>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                    <i class="far fa-heart" id="heart"></i>
                                                <?php endif; ?>
                                            </a>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                            <div class="product-content">
                                <div class="inner">
                                    <h5 class="title">
                                        <a href="<?php echo e(route('product.show' , $product->id )); ?>">
                                            <?php if( app()->getLocale() == 'en' ): ?>
                                                <?php echo e($product->name_en); ?>

                                            <?php elseif( app()->getLocale() == 'ar' ): ?>
                                                <?php echo e($product->name_ar); ?>

                                            <?php endif; ?>
                                        </a></h5>
                                    <div class="product-price-variant">
                                        <?php if($product->discount > 0): ?>
                                            <span class="price old-price">
                                                    <?php echo e(__('lang.sar') . ' ' . str_replace(',', '', number_format( $product->price  + (($tax_tax/100) * $product->price) , 2))); ?>

                                                </span>
                                            <span
                                                class="price current-price"><?php echo e(__('lang.sar') . ' ' .  str_replace(',', '', number_format(($product->price-($product->price*$product->discount/100))  + (($tax_tax/100) * $product->price) , 2))); ?></span>
                                        <?php else: ?>
                                            <span class="price current-price">
                                                    <?php echo e(__('lang.sar') . ' ' . str_replace(',', '', number_format( $product->price  + (($tax_tax/100) * $product->price) , 2))); ?>

                                                </span>
                                        <?php endif; ?>
                                    </div>
                                    <span class="text-tax"><?php echo e(__('lang.tax_pro')); ?></span>
                                    <div class="color-variant-wrapper">
                                        <ul class="color-variant">
                                            <?php $__currentLoopData = $product->colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colors): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li class="mx-2 color-extra-01">
                                                    <span style="background-color:<?php echo e($colors->color); ?>" class="color"></span>
                                                </li>



                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- End Single Product  -->
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


            </div>
            
            
            
        </div>
        <!-- End .container -->
    </div>
    <!-- End Shop Area  -->

    <div class="container newsletter axil-newsletter-area axil-section-gap pt--0" id="subscribe">
        <div class="row m-3">
            <div class="col col-6 p-5">
                <h6 class="pt-5 pb-3"><?php echo e(__('lang.Newsletter')); ?></h6>
                <h1 class="pb-3"><?php echo e(__('lang.Get_weekly_update')); ?></h1>
                <form action="<?php echo e(route('subscribe.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="input-group newsletter-form mb-5">
                        <div class="position-relative mb--15 w-50">
                            <input placeholder="example@gmail.com" type="text" name="email"
                                   class="<?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
                        </div>
                        <button type="submit" class="axil-btn mb--15">
                            <?php echo e(__('lang.subscribe')); ?>

                        </button>
                    </div>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                    <div class="alert text-danger mt-2"><?php echo e($message); ?></div>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </form>
            </div>
            <div class="col col-6" style="background-image: url(<?php echo e(asset('web/assets/images/istockphoto.jpg')); ?>);background-size:cover;opacity:0.8;">
                
            </div>
        </div>
    </div>
    <!-- Start Axil Newsletter Area  -->
    
    <!-- End Axil Newsletter Area  -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script src="<?php echo e(asset('dashboard/assets/plugins/custom/datatables/datatables.bundle.js')); ?>"></script>

    <script>
        $(".qtybtn").on("click", function () {
            var $button = $(this);
            var oldValue = $button.parent().find("input").val();
            if ($button.hasClass("inc")) {
                var newVal = parseFloat(oldValue) + 1;
            } else {
                // Don't allow decrementing below zero
                if (oldValue > 0) {
                    var newVal = parseFloat(oldValue) - 1;
                } else {
                    newVal = 0;
                }
            }
            $button.parent().find("input").val(newVal);
        });

        $(document).on('click', '#cart-btn', function (e) {

            var quantity = $('#out_quantity').val();

            $('#in_quantity').attr('value', quantity);

            var color = $('input[name="color"]:checked').data('color');

            $('#colorForm').val(color);

        });

        $(document).on('click', '#add_fav', function (e) {
            var id = $(this).data('id');
            if ('<?php echo e(\Illuminate\Support\Facades\Auth::user()); ?>') {
                $(this).children('a').children('.fa-heart').toggleClass("red-color");
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("product.add_fav")); ?>',
                    data: {
                        'user_id': '<?php echo e(\Illuminate\Support\Facades\Auth::id()); ?>',
                        'product_id': id,
                    },
                    success: function (response) {
                        // console.log(name_id);
                        // if (response == 'delete Done') {
                        //     $('.fa-heart', '#' + name_id).css("color", "blackblack");
                        // } else {
                        //     $('.fa-heart', '#' + name_id).css("color", "red");
                        // }
                    }
                });
            }
            else {
                window.location.href = "<?php echo e(route('login')); ?>";
            }
        });
    </script>

    <script>
        var lang = '<?php echo e(\Illuminate\Support\Facades\App::getLocale()); ?>';
        $('.eye-modal').click(function () {
            var id = $(this).data('id');
            $.ajax({
                type: 'get',
                url: "<?php echo e(url('products/getData')); ?>/" + id,
                success: function (data) {
                    console.log(data);
                    $('#out_quantity_out').val(1);
                    $('#product_iddd').attr('value', data.product.id);
                    $('#add_favadd_fav').attr('data-id', data.product.id);
                    var product_qty = $('#product_qty').val();
                    $('#in_quantity').attr('value', product_qty);
                    $('#product-image').attr('src', '')
                    $('#product-image').attr('src', '/dashboard/images/' + data.product.image)
                    $('#product-title').text('')
                    if (lang == 'en') {
                        $('#product-title').text(data.product.name_en);
                    } else {
                        $('#product-title').text(data.product.name_ar);
                    }
                    $('#product-price').text('')
                    $('#product-price').text(data.product.price)
                    $('#description').text('')
                    // if (lang == 'en') {
                    //     $('#description').text(data.product.des_en);
                    // } else {
                    //     $('#description').text(data.product.des_ar);
                    // }
                    $('#popup_image').attr('href', '');
                    $('#popup_image').attr('href', '/dashboard/images/' + data.product.image);
                    $('#dicount_text').text('');
                    if (data.product.discount > 0 ) {
                        $('#dicount_text').css('display' , 'inline-flex').text(data.product.discount + ' % OFF');
                    } else {
                        $('#dicount_text').css('display' , 'none');
                    }
                    $('#count_reviews').text(data.product.reviews_count);
                    const boxes = document.querySelectorAll('#show_img');
                    boxes.forEach(box => {
                        box.remove();
                    });
                    data.product.imageable.forEach(myFunction);

                    function myFunction(item) {
                        html(item.image);
                    }

                    const boxColors = document.querySelectorAll('#product_colors');
                    boxColors.forEach(box => {
                        box.remove();
                    });
                    data.product.colors.forEach(myFunction2);
                    console.log(data.product.colors);

                    function myFunction2(item) {
                        html2(item);
                        $('input[name="color_input"]').attr('checked', 'checked');

                    }


                    const box_reviews = document.querySelectorAll('#box_reviews');
                    box_reviews.forEach(box => {
                        box.remove();
                    });

                    if (data.product.reviews_sum_rate != null) {
                        for (var i = 1; i <= data.product.reviews_sum_rate / data.product.reviews_count; i++) {
                            const show_reviews = document.getElementById("div_reviews");
                            let reviews = `
                        <i class="fas fa-star" id="box_reviews"></i>
                        `;
                            show_reviews.insertAdjacentHTML("afterbegin", reviews);
                        }
                    } else {
                        const show_reviews = document.getElementById("div_reviews");
                        let reviews = `
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                                <i class="fal fa-star" id="box_reviews"></i>
                        `;
                        show_reviews.insertAdjacentHTML("afterbegin", reviews);
                    }

                    const show_description = document.querySelectorAll('#show_description');
                    show_description.forEach(box => {
                        box.remove();
                    });

                    console.log(data.product.specifications);
                    data.product.specifications.forEach(myFunction3);

                    function myFunction3(item) {
                        html3(item);
                    }

                    if (data.product.favorite.length != 0) {
                        $('#add_favadd_fav').children('a').children('button').children('.fa-heart').addClass("red-color-single");
                    } else {
                        $('#add_favadd_fav').children('a').children('button').children('.fa-heart').removeClass("red-color-single");
                    }
                    // $('#add_favadd_fav').attr('data-id', data.product.id);

                },
                error: function (data) {
                    console.log('data')
                },

            });
        });

        function html(image) {
            const show_images = document.getElementById("show_images");
            let business = `
               <div class="small-thumb-img" id="show_img">
                    <img src="<?php echo e(Request::root() . '/dashboard/images/'); ?>${image}"
                        alt="thumb image">
                </div>`;
            show_images.insertAdjacentHTML("afterbegin", business);
        }

        function html2(color) {
            const show_color = document.getElementById("products_colors");
//             let cc = `
//             <!--                 <div class="container-color-box d-flex" id="product_colors">-->
// <!--                    <p style="color: black; margin: 5px"></p>-->
// <!--                    <input name="color" class="color color_input" type="radio" id="${color}"-->
//                             value="${color}" data-color="${color}"/>
// <!--                    <label-->
// <!--                        class="color-name d-flex justify-content-center align-items-center mx-2 py-1 px-3"-->
// <!--                        for="${color}">-->
// <!--                        ${color}-->
// <!--                    </label>-->
// <!--                </div>-->
// `;
//             let colors = `
//                 <li class="mx-2 color-extra-01" id="product_colors">
//                     <span style="background-color:${color}" class="color"></span>
//                 </li>`;
            let colors = `
                <div class="container-color-box d-flex mb-4" id="product_colors">
                    <input name="color_input" class="color" type="radio" id="color-${color.id}"
                        value="${color.id}" data-color="${color.color}"/>
                    <label for="color-${color.id}" style="--myVar:${color.color};"></label>
                </div>
                `;
            show_color.insertAdjacentHTML("afterbegin", colors);
        }

        function html3(description) {
            const show_descriptions = document.getElementById("show_descriptions");
            if (lang == 'ar') {
                if (description.other_option_ar != null) {
                    var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_ar}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_ar}
                        </span>
                        <span class="description-text">
                            ${description.other_option_ar}
                        </span>
                    </div>
                </div>
                `;
                } else {
                    var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_ar}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_ar}
                        </span>
                    </div>
                </div>
                `;
                }

            } else {
                if (description.other_option_en != null) {
                    var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_en}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_en}
                        </span>
                        <span class="description-text">
                            ${description.other_option_en}
                        </span>
                    </div>
                </div>
                `;
                } else {
                    var descriptions = `
                <div class="d-flex align-items-center col-sm-12" id="show_description" style="margin-bottom: 3px">
                    <h6 class="mb-0">
                    ${description.title_en}
                    </h6>
                    <div class="box-container d-flex flex-wrap mx-3">
                        <span class="description-text">
                            ${description.option_en}
                        </span>

                    </div>
                </div>
                `;
                }

            }

            show_descriptions.insertAdjacentHTML("afterbegin", descriptions);
        }


        // $(document).on('click', '#add_favadd_fav', function (e) {
        $('#add_favadd_fav').click(function (e) {
            e.preventDefault();
            //     $(document).off("click", "#add_favadd_fav").on("click", "#add_favadd_fav", function (e) {
            var id = $(this).data('id');
            if ('<?php echo e(\Illuminate\Support\Facades\Auth::user()); ?>') {
                $(this).children('a').children('button').children('.fa-heart').toggleClass("red-color-single");
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
                $.ajax({
                    type: 'POST',
                    url: '<?php echo e(route("product.add_fav")); ?>',
                    data: {
                        'user_id': '<?php echo e(\Illuminate\Support\Facades\Auth::id()); ?>',
                        'product_id': id,
                    },
                    success: function (response) {
                    }
                });
            } else {
                window.location.href = "<?php echo e(route('login')); ?>";
            }
        });

        $(document).on('click', '.add-product', function (e) {
            var quantity = $('#out_quantity_out').val();

            $('#in_quantity_in').val(quantity);

            var color = $('input[name="color_input"]:checked').data('color');


            $('#colorForm_colorForm').val(color);

        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.front_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/web/product/product_types.blade.php ENDPATH**/ ?>