<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>" dir="<?php echo e(app()->getLocale() == 'en' ? 'ltr' : 'rtl'); ?>"
    direction="<?php echo e(app()->getLocale() == 'en' ? 'ltr' : 'rtl'); ?>">

<head>
    <meta charset="utf-8">
    <title><?php echo e($order->user->user_name); ?> </title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="https://code.jquery.com/jquery-1.10.2.min.js"></script>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/css/bootstrap.min.css" rel="stylesheet">
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.4.1/dist/js/bootstrap.bundle.min.js"></script>
    <style>
        @media print {

            .no-print {
                display: none;
            }
        }

        .fw-bold{
            font-weight: 800
        }
      

    </style>
</head>

<body>
    <link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" />
    <div class="page-content container">
        <div class="page-header text-blue-d2">
            
            <div class="page-tools no-print">
                <div class="action-buttons">
                    <a class="btn bg-white btn-light mx-1px text-95" href="<?php echo e(url(app()->getLocale() . '/')); ?>">
                        <?php echo e('new net work'); ?>

                    </a>
                    <!-- Using FontAwesome for the print icon -->
                    <button id="printButton" class="btn bg-white btn-light mx-1px text-95">
                        <i class="fa fa-print"></i> 
                    </button>

                </div>
            </div>
        </div>
        <div class="container px-0">
            <div class="row mt-4">
                <div class="col-12 col-lg-12">
                    <div class="row">
                        <div class="col-12">
                            <div class="text-center text-150">
                                
                                <a href="<?php echo e(url(\Illuminate\Support\Facades\App::getLocale() . '/')); ?>"
                                    class="logo logo-dark">
                                    <img id="logo-img-element" src="<?php echo e(Request::root() . '/dashboard/images/' . \App\Models\Settings::where('key_id', 'logo')->first()->value); ?>"
                                        alt="<?php echo e(env('APP_NAME')); ?>"
                                        style=" height:80px;object-fit:cover; padding: 10px;">

                                </a>
                                <br>
                                <span class="text-default-d3">شركة الشبكة الجديدة للتجارة</span>
                            </div>
                        </div>
                    </div>
                    <hr class="row brc-default-l1 mx-n1 mb-4" />


                    <div class="row font-16">
                        <div class="col-sm-6">
                            <div>
                                <span class="text-sm text-grey-m2 align-middle"><?php echo e(__('lang.To')); ?>:</span>
                                <span
                                    class="text-600 text-110  align-middle"><?php echo e($order->user->first_name ?? $order->user->user_name); ?></span>
                            </div>
                            <div class="text-grey-m2">
                                <div class="my-1">
                                    <?php if(app()->getLocale() == 'en'): ?>
                                        <?php echo e($order->addresses->cities->countries->name_en); ?>

                                    <?php else: ?>
                                        <?php echo e($order->addresses->cities->countries->name_ar); ?>

                                    <?php endif; ?>,
                                    <?php if(app()->getLocale() == 'en'): ?>
                                        <?php echo e($order->addresses->cities->name_en); ?>

                                    <?php else: ?>
                                        <?php echo e($order->addresses->cities->name_ar); ?>

                                    <?php endif; ?>
                                </div>
                                <div class="my-1">
                                    <?php echo e($order->addresses->street); ?>

                                    , <?php echo e($order->addresses->district); ?>

                                </div>
                                <div class="my-1"><i class="fa fa-phone fa-flip-horizontal text-secondary"></i> <b
                                        class="text-600">
                                        <?php echo e($order->user->email); ?>

                                    </b></div>
                            </div>
                        </div>

                        <div class="text-95 col-sm-6 align-self-start d-sm-flex justify-content-end">
                            <hr class="d-sm-none" />
                            <div class="text-grey-m2">
                                <div class="mt-1 mb-2 text-secondary-m1 text-600 text-125">
                                    <?php echo e(__('lang.order_summery')); ?>

                                </div>
                                <div class="my-1 my-lg-2"><i class="fa fa-circle text-blue-m2 text-xs mr-1"></i> <span
                                        class="text-600 text-90">رقم الطلب:</span> #<?php echo e($order->number); ?>

                                </div>
                                <div class="my-1 my-lg-2"><i class="fa fa-circle text-blue-m2 text-xs mr-1"></i> <span
                                        class="text-600 text-90"><?php echo e(__('lang.created_at')); ?>:</span><?php echo e(\Carbon\Carbon::parse($order->create_date, 'UTC')->isoFormat('MMMM Do YYYY')); ?>

                                </div>
                                <div class="my-1 my-lg-2"><i class="fa fa-circle text-blue-m2 text-xs mr-1"></i> <span
                                        class="text-600 text-90"><?php echo e(__('lang.status')); ?>:</span>
                                    <?php if($order->payment_status == 'pending' || $order->payment_status == 'failed'): ?>
                                        <span
                                            class="badge badge-warning badge-pill px-25"><?php echo e(__('lang.Unpaid')); ?></span>
                                    <?php else: ?>
                                        <span class="badge badge-success badge-pill px-25"><?php echo e(__('lang.paid')); ?></span>
                                    <?php endif; ?>
                                     <?php if($order->payment_method == 'Emkan'): ?>
                                       <br>
                                       <i class="fa fa-circle text-blue-m2 text-xs mr-1 mt-2"></i>
                            <span class="text-sm text-grey-m2 align-middle">رقم القسيمة </span>
                            <span class="text-600 text-110 text-blue align-middle">
                                <?php echo e($order->voucherCode); ?>

                            </span>
                            <br>
                             <i class="fa fa-circle text-blue-m2 text-xs mr-1 mt-2"></i>
                            <span class="text-sm text-grey-m2 align-middle">رقم الهويه </span>
                            <span class="text-600 text-110 text-blue align-middle">
                                <?php echo e($order->customerId); ?>

                            </span>
                              <br>
 <i class="fa fa-circle text-blue-m2 text-xs mr-1 mt-2"></i>
                            <span class="text-sm text-grey-m2 align-middle">رقم الطلب </span>
                            <span class="text-600 text-110 text-blue align-middle">
                                <?php echo e($order->applicationId); ?>

                            </span>
                              <br>
                        <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    </div>

                    <table class="mt-4 w-100 mb-3" style="border: 1px solid #000; border-collapse: collapse;">
                        <thead class="text-600 text-white bgc-default-tp1 py-25">
                            <td class="" style="border: 1px solid #000;">#</td>
                            <td class="" style="border: 1px solid #000;"><?php echo e(__('lang.Product')); ?></td>
                            <td class="" style="border: 1px solid #000;"><?php echo e(__('lang.Qty')); ?></td>
                            <td class="" style="border: 1px solid #000;"><?php echo e(__('lang.price')); ?></td>
                            <td class="" style="border: 1px solid #000;"><?php echo e(__('lang.tax')); ?></td>
                            <td class="" style="border: 1px solid #000;"><?php echo e(__('lang.total')); ?></td>
                        </thead>
                        <?php 
                          $tax=0;
                          $price=0;
                          $total=0;
                        ?>
                        <tbody class="text-95 text-secondary-d3">
                         <?php
    $rowNumber = 1;
    $serials = $order->serail ? explode(',', $order->serail) : [];
?>

<?php $__currentLoopData = $order->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $products_x): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php for($j = 0; $j < $products_x->pivot->quantity; $j++): ?>
        <tr class="mb-2 mb-sm-0 py-25 bgc-default-l4">
            <td style="border: 1px solid #000;"><?php echo e($rowNumber++); ?></td>
            <td style="border: 1px solid #000;">
                <?php if(app()->getLocale() == 'en'): ?>
                    <?php echo e($products_x->name_en); ?>

                <?php else: ?>
                    <?php echo e($products_x->name_ar); ?>

                <?php endif; ?>

                
                <?php if(isset($serials[$rowNumber - 2])): ?> 
                    <p>SERIAL NO: <?php echo e(trim($serials[$rowNumber - 2])); ?></p>
                <?php endif; ?>
            </td>

            <td style="border: 1px solid #000;">1</td> 

            <td style="border: 1px solid #000;">
                <?php if($products_x->discount > 0): ?>
                    <?php echo e(number_format($products_x->price - ($products_x->price * $products_x->discount) / 100 - (15 / 100) * $products_x->price, 2) . ' ' . __('lang.sar')); ?>

                    <?php
                        $price += round($products_x->price - ($products_x->price * $products_x->discount) / 100 - (15 / 100) * $products_x->price, 2);
                    ?>
                <?php else: ?>
                    <?php echo e(number_format($products_x->price - (15 / 100) * $products_x->price, 2) . ' ' . __('lang.sar')); ?>

                    <?php
                        $price += round($products_x->price - (15 / 100) * $products_x->price, 2);
                    ?>
                <?php endif; ?>
            </td>

            <td style="border: 1px solid #000;">
                <?php echo e(number_format((15 / 100) * $products_x->price, 2) . ' ' . __('lang.sar')); ?>

                <?php 
                    $tax += round((15 / 100) * $products_x->price, 2);
                ?>
            </td>

            <td style="border: 1px solid #000;">
                <?php if($products_x->discount > 0): ?>
                    <?php echo e(number_format($products_x->price - ($products_x->price * $products_x->discount) / 100 + ($tax_tax / 100) * $products_x->price, 2) . ' ' . __('lang.sar')); ?>

                <?php else: ?>
                    <?php echo e(number_format($products_x->price + ($tax_tax / 100) * $products_x->price, 2) . ' ' . __('lang.sar')); ?>

                <?php endif; ?>
            </td>
        </tr>
    <?php endfor; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            <tr class="mb-2 mb-sm-0 py-25 bgc-default-l4">
                                <td  class="fw-bold text-center"  colspan="3" style="border: 1px solid #000;">المجموع</td>
                                <td class="fw-bold" style="border: 1px solid #000;"><?php echo e($price .' '. __('lang.sar')); ?></td>
                                <td class="fw-bold" style="border: 1px solid #000;"><?php echo e($tax .' '. __('lang.sar')); ?></td>
                                <td class="fw-bold" style="border: 1px solid #000;"><?php echo e(number_format(($tax+$price),2).' '. __('lang.sar')); ?></td>

                            </tr>
                        </tbody>
                    </table>

                    <div class="row border-b-2 brc-default-l2"></div>


                    <div>
                        <p class="text-600 mb-0"><?php echo e(__('lang.contact_information')); ?></p>
                        <div class="d-flex flex-column-reverse flex-sm-row mt-2 font-16">
                            <div class="col-12 col-sm-7 text-grey-d2 text-95 mt-2 mt-lg-0">
                                <div class="my-1"><i class="fa fa-phone fa-flip-horizontal text-secondary"></i> <b
                                        class="text-600">
                                        <?php echo e(\App\Models\Settings::where('key_id', 'email')->first()->value); ?>

                                    </b>
                                </div>
                                <div class="my-1"><i class="fa fa-phone fa-flip-horizontal text-secondary"></i> <b
                                        class="text-600">
                                        <?php echo e(\App\Models\Settings::where('key_id', 'phone')->first()->value); ?>

                                    </b>
                                </div>
                                <div class="my-1"><i class="fa fa-whatsapp fa-flip-horizontal text-secondary"></i> <b
                                        class="text-600">
                                        <a
                                            href="<?php echo e(\App\Models\Settings::where('key_id', 'whats')->first()->value); ?>"><?php echo e(\App\Models\Settings::where('key_id', 'phone')->first()->value); ?></a>

                                    </b>
                                </div>
                                <div>
                                    <span class="text-sm text-grey-m2 align-middle">الرقم الضريبي</span>
                                    <span class="text-600 text-110 text-blue align-middle">
                                       310766722300003
                                    </span>
                                </div>
                                <div>
                                    <span class="text-sm text-grey-m2 align-middle">العنوان الوطني:</span>
                                    <span class="text-600 text-110 text-blue align-middle">
                                        <?php echo e(\App\Models\Settings::where('key_id', 'location_' . app()->getLocale())->first()->value); ?>

                                    </span>
                                </div>
                                
                            </div>
                            <div class="col-12 col-sm-5 text-grey text-90 order-first order-sm-last">
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                                
                            </div>
                        </div>
                    </div>
                    <hr />
                    <div class="d-flex align-items-center justify-content-between pb-3 font-16">
                        
                        <?php if($order->payment_status == 'pending' || $order->payment_status == 'failed'): ?>
                            <?php if($order->payment_method == 'Emkan' && $order->payment_status == 'failed'): ?>
                                <a class="btn btn-info btn-bold px-4 float-right mt-lg-0"
                                    href="<?php echo e(route('emcan.create', ['id' => $order->id])); ?>">
                                    <?php echo e(__('lang.Pay_Now')); ?>

                                </a>
                            <?php elseif($order->payment_method == 'Emkan' && $order->payment_status == 'pending'): ?>
                            <?php else: ?>
                                <a class="btn btn-info btn-bold px-4 float-right mt-lg-0"
                                    href="<?php echo e(route('tap.create', ['id' => $order->id])); ?>">
                                    <?php echo e(__('lang.Pay_Now')); ?>

                                </a>
                            <?php endif; ?>
                     
                        <?php endif; ?>
                        
                        
                        
                        
                       
                    </div>

                </div>
            </div>
        </div>
    </div>

    <?php if(app()->getLocale() == 'ar'): ?>
        <style type="text/css">
            body {
                text-align: inherit;
            }

            .text-right {
                text-align: left !important;
            }
        </style>
    <?php endif; ?>
    <style>
        .text-secondary-d1 {
            color: #728299 !important;
        }

        .page-header {
            margin: 0 0 1rem;
            padding-bottom: 1rem;
            padding-top: .5rem;
            border-bottom: 1px dotted #e2e2e2;
            display: -ms-flexbox;
            display: flex;
            -ms-flex-pack: justify;
            justify-content: space-between;
            -ms-flex-align: center;
            align-items: center;
        }

        .page-title {
            padding: 0;
            margin: 0;
            font-size: 1.75rem;
            font-weight: 300;
        }

        .brc-default-l1 {
            border-color: #dce9f0 !important;
        }

        .ml-n1,
        .mx-n1 {
            margin-left: -.25rem !important;
        }

        .mr-n1,
        .mx-n1 {
            margin-right: -.25rem !important;
        }

        .mb-4,
        .my-4 {
            margin-bottom: 1.5rem !important;
        }

        hr {
            margin-top: 1rem;
            margin-bottom: 1rem;
            border: 0;
            border-top: 1px solid rgba(0, 0, 0, .1);
        }

        .text-grey-m2 {
            color: #888a8d !important;
        }

        .text-success-m2 {
            color: #86bd68 !important;
        }

        .font-bolder,
        .text-600 {
            font-weight: 600 !important;
        }

        .text-110 {
            font-size: 110% !important;
        }

        .text-blue {
            color: #8b3278 !important;
        }

        .pb-25,
        .py-25 {
            padding-bottom: .75rem !important;
        }

        .pt-25,
        .py-25 {
            padding-top: .75rem !important;
        }

        .bgc-default-tp1 {
            background-color: rgb(139 50 120) !important;
        }

        .bgc-default-l4,
        .bgc-h-default-l4:hover {
            background-color: #f3f8fa !important;
        }

        .page-header .page-tools {
            -ms-flex-item-align: end;
            align-self: flex-end;
        }

        .btn-light {
            color: #757984;
            background-color: #f5f6f9;
            border-color: #dddfe4;
        }

        .w-2 {
            width: 1rem;
        }

        .text-120 {
            font-size: 120% !important;
        }

        .text-primary-m1 {
            color: #4087d4 !important;
        }

        .text-danger-m1 {
            color: #dd4949 !important;
        }

        .text-blue-m2 {
            color: #8b3278  !important;
        }

        .text-150 {
            font-size: 150% !important;
        }

        .text-60 {
            font-size: 60% !important;
        }

        .text-grey-m1 {
            color: #7b7d81 !important;
        }

        .align-bottom {
            vertical-align: bottom !important;
        }

        td {
            padding: 1rem;
        }

        @media screen and (max-width: 991.98px) {
            img {
                height: 50px !important;
            }

            .page-title {
                font-size: 1.2rem;
            }

            .btn-light {
                font-size: 14px !important;
            }

            .text-default-d3 {
                font-size: 18px;
            }

            .font-16 {
                font-size: 14px;
            }

            td {
                padding: 0.5rem;
                font-size: 12px;
            }

            .text-150 {
                font-size: 16px !important;
                font-weight: bold;
            }

            .text-110 {
                font-size: 13px !important;
            }
        }
    </style>
    
  <script>
    $(document).ready(function() {
    $('#printButton').on('click', function() {
        window.print();
    });
});

  </script>
</body>

</html>
<?php /**PATH /home/cujzkrmy/public_html/newnetwork/project/resources/views/web/order/pdf.blade.php ENDPATH**/ ?>