@extends('layouts.front_layout')

@section('css')
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root {
            --brand: #7e2a6f;
            --brand-2: #9c3b8e;
            --ink: #1f2937;
            --muted: #6b7280;
            --bg: #fbf7fc;
        }

        body {
            background: radial-gradient(1200px 600px at 80% -100px, #f1e7f3 0%, transparent 60%), var(--bg);
        }

        .shell {
            max-width: 980px;
            margin-inline: auto;
            padding: 32px 16px;
        }

        .hero {
            background: linear-gradient(135deg, var(--brand) 0%, var(--brand-2) 100%);
            color: #fff;
            border-radius: 20px 20px 0 0;
            padding: 28px 24px;
            text-align: center;
        }

        .hero h4 {
            margin: 0;
            font-weight: 800;
            letter-spacing: .2px
        }

        .hero small {
            opacity: .85
        }

        /* card glass */
        .panel {
            backdrop-filter: blur(8px);
            background: rgba(255, 255, 255, .8);
            border: 1px solid rgba(126, 42, 111, .12);
            border-top: 0;
            border-radius: 0 0 20px 20px;
            box-shadow: 0 12px 40px rgba(0, 0, 0, .06);
            overflow: hidden;
        }

        .form-wrap {
            padding: 28px;
        }

        @media (min-width: 992px) {
            .form-grid {
                display: grid;
                grid-template-columns: 1.2fr .8fr;
                gap: 28px;
            }

            .form-wrap {
                padding: 36px 40px;
            }
        }

        /* side with features (optional image/brand) */
        .side {
            background: linear-gradient(180deg, #ffffff 0%, #faf5fb 100%);
            border: 1px dashed rgba(126, 42, 111, .18);
            border-radius: 16px;
            padding: 20px;
        }

        .feat {
            display: flex;
            gap: 10px;
            align-items: flex-start;
            margin-bottom: 12px
        }

        .feat i {
            color: var(--brand)
        }

        .badge-soft {
            display: inline-block;
            padding: .35rem .6rem;
            border-radius: 999px;
            background: rgba(126, 42, 111, .08);
            color: var(--brand);
            font-weight: 600;
            font-size: .85rem;
        }

        /* floating labels */
        .float .form-control,
        .float .form-select {
            height: 56px;
            border-radius: 14px;
            border: 1.8px solid #ece6ef;
            background: #fff;
        }

        .float .form-control:focus,
        .float .form-select:focus {
            border-color: var(--brand);
            box-shadow: 0 0 0 .18rem rgba(126, 42, 111, .12);
        }

        .float .form-label {
            color: var(--muted)
        }

        .muted {
            color: var(--muted);
            font-size: .92rem
        }

        /* input icons */
        .with-icon {
            position: relative
        }

        .with-icon i {
            position: absolute;
            inset-inline-end: 12px;
            inset-block: 0;
            margin: auto;
            height: 1em;
            color: var(--brand);
            pointer-events: none;
        }

        .with-icon .form-control {
            padding-inline-end: 40px
        }

        /* button */
        .btn-brand {
            background: var(--brand);
            border: 0;
            height: 56px;
            border-radius: 14px;
            font-weight: 700;
        }

        .btn-brand:hover {
            background: #671f60
        }

        <style> :root {
            --brand: #7e2a6f;
            --ink: #1f2330;
            --muted: #7b7f8a;
        }

        /* وضوح النص */
        .form-control,
        .form-select {
            color: var(--ink);
            border: 1.8px solid #e9e2ec;
            background: #fff;
            height: 56px;
            border-radius: 14px;
        }

        .form-control::placeholder {
            color: #a8a0ad;
        }

        .form-control:focus,
        .form-select:focus {
            border-color: var(--brand);
            box-shadow: 0 0 0 .18rem rgba(126, 42, 111, .12);
        }

        /* إصلاح floating label مع select */
        .form-floating>.form-select {
            padding-top: 1.625rem;
            /* مساحة للّيبِل */
            padding-bottom: .625rem;
        }

        .form-floating>label {
            color: var(--muted);
            padding: .6rem .9rem;
            height: auto;
        }

        /* RTL: حرك الليبل لليمين */
        [dir="rtl"] .form-floating>label {
            right: .75rem;
            left: auto;
        }

        /* لما يكون في قيمة/فوكس خلّي الليبل يطفو بوضوح */
        .form-floating>.form-control:focus~label,
        .form-floating>.form-control:not(:placeholder-shown)~label,
        .form-floating>.form-select:focus~label,
        .form-floating>.form-select.is-filled~label {
            opacity: .85;
            transform: scale(.85) translateY(-.6rem);
            background: #fff;
            /* يمنع تداخل النص مع الحقل */
            padding-inline: .35rem;
            border-radius: 6px;
        }

        /* أيقونة داخل الحقل */
        .with-icon {
            position: relative;
        }

        .with-icon i {
            position: absolute;
            inset-inline-end: 12px;
            inset-block: 0;
            margin: auto;
            height: 1em;
            color: var(--brand);
            pointer-events: none;
        }

        .with-icon .form-control {
            padding-inline-end: 40px;
        }

        /* زر */
        .btn-brand {
            background: var(--brand);
            border: 0;
            height: 56px;
            border-radius: 14px;
            font-weight: 700;
        }

        .btn-brand:hover {
            background: #671f60;
        }

        .form-floating>label {
            right: 14px !important;
        }

        option {
            font-size: 12px;
            font-weight: 700;
        }
    </style>

    </style>
@endsection

@section('content')
    <div class="shell">
        <div class="hero">
            <h4 style="color: #fff">طلب مسبق للهواتف ايفون  17 </h4>
            <p style="color: #fff">املأ بياناتك وسيتم التواصل معك لتأكيد الطلب</p>
        </div>

        <div class="panel">
            <div class="form-wrap">
                <div class="form-grid">
                    {{-- العمود الأيسر: النموذج --}}
                    <form action="{{ route('store_preorder') }}" method="post" class="float">
                        @csrf

                        {{-- الاسم --}}
                        <div class="mb-3 with-icon form-floating">
                            <input type="text" class="form-control fw-bold" id="name" name="name" placeholder="اسمك"
                                value="{{ old('name') }}" required style="color: #7e2a6f;">
                            <label for="name" class="fw-bold" style="color: black;">الاسم</label>
                            <i class="bi bi-person"></i>
                        </div>

                        {{-- الجوال --}}
                        <div class="mb-3 with-icon form-floating">
                            <input type="text" class="form-control fw-bold pt-5" id="phone" name="phone"
                                placeholder="05xxxxxxxx" value="{{ old('phone') }}" required style="color: #7e2a6f;">
                            <label for="phone" class="fw-bold" style="color: black;">رقم الهاتف</label>
                            <i class="bi bi-telephone"></i>

                        </div>

                        {{-- شبكة الحقول --}}
                        <div class="row g-3">

                            <div class="col-md-6 form-floating">
                                <select class="form-select fw-bold" id="color" name="color" style="    font-size: 15px;color: #7e2a6f;">
                                    <option value="أسود" {{ old('color') == 'أسود' ? 'selected' : '' }}>أسود </option>
                                    <option value="أخضر" {{ old('color') == 'أخضر' ? 'selected' : '' }}>أخضر </option>
                                    <option value="أزرق" {{ old('color') == 'أزرق' ? 'selected' : '' }}>أزرق</option>
                                    <option value="بنفسجي" {{ old('color') == 'بنفسجي' ? 'selected' : '' }}>بنفسجي </option>
                                    <option value="أبيض" {{ old('color') == 'أبيض' ? 'selected' : '' }}>أبيض</option>
                                    <option value="برتقالي" {{ old('color') == 'برتقالي' ? 'selected' : '' }}>برتقالي
                                    </option>
                                </select>
                                <label for="color" class="fw-bold" style="color: black;">اللون</label>
                            </div>
                            <div class="col-md-6 form-floating">
                                <select class="form-select fw-bold" id="phoneSelect" name="phoneSelect" required style="    font-size: 15px;color: #7e2a6f;">
                                    <option value="ايفون 17 عادي" {{ old('color') == 'ايفون 17 عادي' ? 'selected' : '' }}>
                                        ايفون 17 عادي
                                    </option>
                                    <option value="ايفون 17 برو" {{ old('color') == 'رمادي' ? 'selected' : '' }}>ايفون 17
                                        برو
                                    </option>
                                    <option value="ايفون 17 بروماكس"
                                        {{ old('color') == 'ايفون 17 بروماكس' ? 'selected' : '' }}>ايفون 17 بروماكس
                                    </option>
                                    <option value="ايفون 17 اير" {{ old('color') == 'ايفون 17 اير' ? 'selected' : '' }}>
                                        ايفون 17 اير
                                    </option>

                                </select>
                                <label for="phoneSelect" class="fw-bold" style="color: black;">نوع الجهاز</label>
                            </div>

                            <div class="col-md-6 form-floating">
                                <select class="form-select fw-bold" id="storage" name="storage" required style="    font-size: 15px;color: #7e2a6f;">
                                    <option value="128" {{ old('storage') == '128' ? 'selected' : '' }}>128 جيجا
                                    </option>
                                    <option value="256" {{ old('storage') == '256' ? 'selected' : '' }}>256 جيجا
                                    </option>
                                    <option value="512" {{ old('storage') == '512' ? 'selected' : '' }}>512 جيجا
                                    </option>
                                </select>
                                <label for="storage" class="fw-bold" style="color: black;">المساحة</label>
                            </div>

                            <div class="col-md-6 form-floating">
                                <select class="form-select fw-bold" id="deliveryMethod" name="deliveryMethod" required style="    font-size: 15px;color: #7e2a6f;">
                                    <option value="شحن" {{ old('deliveryMethod') == 'شحن' ? 'selected' : '' }}>شحن
                                    </option>
                                    <option value="استلام من الفرع" {{ old('deliveryMethod') == 'من الموقع' ? 'selected' : '' }}>
                                        استلام
                                        من الفرع</option>
                                </select>
                                <label for="deliveryMethod " class="fw-bold" style="color: black;">طريقة التوصيل</label>
                            </div>


                        </div>

                        <button type="submit" class="btn btn-brand w-100 mt-4" style="    color: white;">
                            <i class="bi bi-send ms-1"></i> إرسال الطلب
                        </button>


                    </form>

                    {{-- العمود الأيمن: عناصر ثقة وتسويق بسيطة --}}
                    <div class="side  d-lg-block">
                        <span class="badge-soft mb-3" style="    font-weight: 700;font-size: 17px;">عرض إطلاق</span>
                         <div class="feat"><i class="bi bi-gift"></i>
                            <div style="font-weight: 400;     font-size: 15px;">هدية مجانية قيمة </div>
                        </div>
                        <div class="feat"><i class="bi bi-truck"></i>
                            <div style="font-weight: 400;     font-size: 15px;">شحن مجاني لجميع الطلبات</div>
                        </div>
                        <div class="feat"><i class="bi bi-shield-check"></i>
                            <div style="font-weight: 400;    font-size: 15px;">ضمان سنتين من الوكيل</div>
                        </div>
                       <div class="feat"><i class="bi bi-credit-card"></i>
                            <div style="font-weight: 400;    font-size: 15px;">خيارات دفع مرنة تبدا من 3 اشهر الى 36 شهر </div>
                        </div>
                        <div class="feat"><i class="bi bi-credit-card"></i>
                            <div style="font-weight: 400;    font-size: 15px;">تقسيط مريح بدون دفعه اولى وبدون كفيل</div>
                        </div>
                        <div class="feat"><i class="bi bi-clock-history"></i>
                            <div style="font-weight: 400;    font-size: 15px;">أولوية تسليم لطلبات الحجز المسبق</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
