<div class="product-table-heading">
    <h1 class="color1 title mt-5 h4">
        {{ __('lang.your_cart') }}
    </h1>
    @if( $items->get()->count() > 0 )
        <form action="#" method="POST">
            @csrf
            <button type="submit" class="cart-clear" style="background-color: transparent;">
                {{ __('lang.clear_cart') }} <i class="bi bi-cart-x" style="font-size: 21px;color: red;"></i>
            </button>
        </form>
    @endif
</div>

<div class="table-responsive table-sm">
    <table class="table axil-product-table axil-cart-table mb--40">
        <thead>
        <tr>
            <th scope="col" class="product-remove"></th>
            <th scope="col" class="product-thumbnail">
                {{ __('lang.product') }}
            </th>
            <th scope="col" class="product-title"></th>
            {{-- <th scope="col" class="product-price">
                {{ __('lang.price') }}
            </th> --}}
            {{-- <th scope="col" class="product-quantity text-center">
                {{ __('lang.tax') }}
            </th> --}}
            <th scope="col" class="product-quantity text-center">
                {{ __('lang.quantity') }}
            </th>
            <th scope="col" class="color-row text-center ">
                {{ __('lang.Colors') }}
            </th>
            <th scope="col" class="product-subtotal">
                {{ __('lang.subtotal') }}
            </th>
        </tr>
        </thead>
        <tbody>
        @if( $items->get()->count() > 0 )
            @foreach($items->get() as $item)
                <tr class="shadow-sm  mb-5 mt-3  rounded">
                    <td class="product-remove">
                        <form action="{{ route('cart.delete', ['id' => $item->id]) }}">
                            @csrf
                            @method('DELETE')

                            <button type="submit" class="remove-wishlist" data-id="{{ $item->id }}">
                                <i class="fal fa-times"></i>
                            </button>
                        </form>
                    </td>
                       @php 
   $colors_record = \App\Models\Colors::where("product_id", $item->product->id)->where("color", $item->color)->first();

   @endphp
                    <td class="product-thumbnail">
                        @if($colors_record?->images)

                        <a href="{{ route('product.show', ['id' => $item->product->id]) }}">
                            <img src="{{ Request::root() . '/dashboard/images/' . $colors_record?->images?->image }}"
                                 alt="Digital Product">
                        </a>

                        @else
                        <a href="{{ route('product.show', ['id' => $item->product->id]) }}">
                            <img src="{{ Request::root() . '/dashboard/images/' .  $item->product->image }}"
                                 alt="Digital Product">
                        </a>

                        @endif
                    </td>
                    <td class="product-title">
                        <a href="{{ route('product.show', ['id' => $item->product->id]) }}">
                             @if(app()->getLocale() === 'ar')
                                  {{ $item->product->name_ar }}
                           @else
                                  {{ $item->product->name_en }}
                           @endif
                          <br>
                            @if($item->product->discount > 0)
                            {{  number_format(($item->product->price -($item->product->price * $item->product->discount/100))  + (($tax_tax/100) * $item->product->price) , 2) }}
                              
                                <img
                                                                class="d-inline mx-2"
                                                                src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}"
                                                                width=16>
                            
                        @else
                            {{  number_format($item->product->price + (($tax_tax/100) * $item->product->price) ) }} 
                            <img
                                                                class="d-inline mx-2"
                                                                src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}"
                                                                width=16>
                            
                        @endif
{{--                        {{number_format($item->product->price + (($tax_tax/100) * $item->product->price) ) }}--}}
                            
                        </a>
                    </td>
                    
                    <td class="product-quantity" data-id="{{ $item->id }}" data-title="{{ __('lang.quantity') }}">
                        <div class="pro-qty">
                            <span class="dec qtybtn" id="qty-btn-mix" data-id="{{ $item->id }}">-</span>
                            <span class="text-left" ><input type="number" id="qty_input" max="{{ $item->product->quantity }}"
                                   class="quantity-input" style="pointer-events: none" data-id="{{ $item->id }}"
                                   value="{{ $item->quantity }}">
                            </span>
                            <span class="inc qtybtn" id="qty-btn-max" data-id="{{ $item->id }}">+</span>
                        </div>
                    </td>
                    <td class="product-color" data-title="{{ __('lang.color') }}" >
                        <div class="m-auto"
                            style="background-color: {{ $item->color }}; width: 15px; height: 15px; border-radius: 50%;"
                            title="{{ $item->color }}"></div>
                    </td>

                    <td class="product-subtotal" data-title="{{ __('lang.subtotal') }}" style="font-size: 18px">
                        @if($item->product->discount > 0)
                            {{ number_format(($item->product->price * $item->quantity) - (($item->product->price * $item->quantity) * $item->product->discount/100) + (($tax_tax/100) * ($item->product->price * $item->quantity)) , 2)  }}
                             <img
                                                                class="d-inline mx-2"
                                                                src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}"
                                                                width=16>
                        @else
                            {{ number_format(($item->product->price * $item->quantity) + (($tax_tax/100) * ($item->product->price * $item->quantity)))  }}
                             <img
                                                                class="d-inline mx-2"
                                                                src="{{ asset('web/assets/images/Saudi_Riyal_Symbol.svg') }}"
                                                                width=16>
                        @endif
{{--                        {{ __('lang.sar').' '.number_format(($item->product->price * $item->quantity) + (($tax_tax/100) * ($item->product->price * $item->quantity)) )  }}--}}
                            <br>
                            <span class="text-tax">{{__('lang.tax_pro')}}</span>
                    </td>

                </tr>
            @endforeach
        @else
            <tr>
                <td class="text-center text-danger" colspan="7">
                    {{ __('lang.no_product') }}
                </td>
            </tr>
        @endif
        </tbody>
    </table>
</div>