@extends('layouts.master')

@section('main_title', 'Home Page')
@section('header_title', 'Home')
@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">{{ __('lang.updateproducts') }}</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('dashboard.tags.update', ['id' => $tag->id]) }}" method="post"
                enctype="multipart/form-data">
                @csrf
                @method('put')

                <input type="hidden" name="id" value="{{ $tag->id }}">

                <div class="mb-10">
                    <label class="form-label">{{ __('lang.namear') }}</label>
                    <input type="text" name="name_ar" class="form-control form-control-solid" value="{{ $tag->name_ar }}"
                        required>
                </div>

                <div class="mb-10">
                    <label class="form-label">{{ __('lang.nameen') }}</label>
                    <input type="text" name="name_en" class="form-control form-control-solid" value="{{ $tag->name_en }}"
                        required>
                </div>


                <button type="submit" class="btn btn-primary float-end w-md-25" id="save">Save</button>
            </form>
        </div>
    </div>

@endsection
@section('js')
    {{--    <script src="{{asset('dashboard/assets/js/repeater.js')}}"></script> --}}
    <script src="{{ asset('dashboard/rtl_assets/js/repeater2.js') }}"></script>
    <script>
        $("#repeater").createRepeater({
            showFirstItemToDefault: true,
        });
        $("#repeater2").createRepeater({
            showFirstItemToDefault: true,
        });
    </script>
    <script>
        $(document).ready(function() {
            var index = $('.items').data('index');
            if (index == 0) {
                // $('.items').css('display' , 'none');
                $('div').find("[data-index='" + 0 + "']").css('display', 'none');
            }
        });
    </script>
    <script>
        $(document).on('click', '#save', function() {
            console.log("dsadasd");
            var index = $('.items').data('index');
            if (index == 0) {
                $('div').find("[data-index='" + 0 + "']").remove();
            }
        });
    </script>
@endsection
