@extends('layouts.master')

@section('main_title', 'Home Page')

@section('header_title', 'Home')

@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">{{ __('lang.addTag') }}</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('dashboard.tags.store') }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="mb-10">
                    <label class="form-label">{{ __('lang.namear') }}</label>
                    <input type="text" name="name_ar" value="{{ old('name_ar', '') }}"
                        class="form-control form-control-solid" required>
                </div>
                <div class="mb-10">
                    <label class="form-label">{{ __('lang.nameen') }}</label>
                    <input type="text" name="name_en" value="{{ old('name_en', '') }}"
                        class="form-control form-control-solid" required>
                </div>










                {{--                <div class="mb-10"> --}}
                {{--                    <label class="form-label">{{ __('lang.tax') }}</label> --}}
                {{--                    <input type="number" name="tax" value="{{ old('tax' , '') }}" --}}
                {{--                           class="form-control form-control-solid" required> --}}
                {{--                </div> --}}

                {{--                <div class="mb-10"> --}}
                {{--                    <label class="form-label">{{ __('lang.quantity') }}</label> --}}
                {{--                    <input type="number" name="quantity" value="{{ old('quantity' , '') }}" --}}
                {{--                           class="form-control form-control-solid"  required> --}}
                {{--                </div> --}}






                <button type="submit" class="btn btn-primary float-end w-md-25" id="save">Save</button>
            </form>
        </div>
    </div>
@endsection
@section('js')
    <script src="{{ asset('dashboard/assets/js/repeater.js') }}"></script>
    <script>
        $("#repeater").createRepeater({
            showFirstItemToDefault: true,
        });
        $("#repeater2").createRepeater({
            showFirstItemToDefault: true,
        });
    </script>
    <script>
        $(document).ready(function() {
            var index = $('.items').data('index');
            if (index == 0) {
                // $('.items').css('display' , 'none');
                $('div').find("[data-index='" + 0 + "']").css('display', 'none');
            }
        });
    </script>
    <script>
        $(document).on('click', '#save', function() {
            console.log("dsadasd");
            var index = $('.items').data('index');
            if (index == 0) {
                $('div').find("[data-index='" + 0 + "']").remove();
            }

        });
    </script>
    <script>
        {{-- var fd = {{ old('test') }} --}}
        {{-- $.ajax({ --}}
        {{--    url: '{{ route('products.store') }}', --}}
        {{--    type: 'POST', --}}
        {{--    data: { title: fd }, --}}
        {{--    success: function(response) { --}}
        {{--        console.log(response); --}}
        {{--        // // Update the container element with the new value returned from the Laravel controller --}}
        {{--        // $('#specifications-title-container').html(response); --}}
        {{--    } --}}
        {{-- }); --}}
    </script>
@endsection
