@extends('layouts.master')

@section('main_title', 'Home Page')

@section('header_title', 'Home')

@section('subheader_title', '#XV2')

@section('content')
    <div class="card mb-5 mb-xl-8">
        <div class="card-header border-0 pt-5">
            <h3 class="card-title align-items-start flex-column">
                <span class="card-label fw-bolder fs-3 mb-1">{{ __('lang.New_post') }}</span>
            </h3>
        </div>
        @if ($errors->any())
            <div class="alert alert-danger" style="margin: 15px">
                <ul>
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="card-body py-3">
            <form action="{{ route('branches.store') }}" method="post" enctype="multipart/form-data">
                @csrf
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="title_ar">رابط</label>
                            <input type="text" name="google_link" class="form-control" value="{{ old('google_link') }}"
                                required>
                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category">اسم الفرع</label>
                            <input type="text" name="name_ar" class="form-control" value="{{ old('name_ar') }}" required>

                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category">ساعات العمل</label>
                            <input type="text" name="working_hours" class="form-control"
                                value="{{ old('working_hours') }}" required>

                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category"> الموقع</label>
                            <input type="text" name="location" class="form-control" value="{{ old('location') }}"
                                required>

                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="category"> الهاتف</label>
                            <input type="text" name="phone" class="form-control" value="{{ old('phone') }}" required>

                            @error('title_ar')
                                <div class="alert alert-danger mt-2">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>

                </div>





                <button type="submit" class="btn btn-primary ">إنشاء الفرع</button>


            </form>
        </div>
    </div>
@endsection
