@extends('layouts.front_layout')

@section('title',  __('lang.login'))
@section('css')
    <!-- Favicon -->
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('web/assets/images/favicon.png') }}">

    <!-- CSS
    ============================================ -->

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('web/assets/css/vendor/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ asset('web/assets/css/vendor/font-awesome.css') }}">
    <link rel="stylesheet" href="{{ asset('web/assets/css/vendor/flaticon/flaticon.css') }}">


    @if( app()->getLocale() == 'en')
        <link rel="stylesheet" href="{{ asset('web/assets/css/style.min.css') }}">
        <style>
            .form-group i{
                position: absolute;
                right: 10px;
                top: 15px;
                font-size: 20px;
            }
            .email-login{
        text-align: start;
    }
        </style>
    @elseif( app()->getLocale() == 'ar' )
        <link rel="stylesheet" href="{{ asset('web/rtl_assets/css/style.min.css') }}">
        <style>
            .form-group i {
                position: absolute;
                top: 15px;
                left: 10px;
                font-size: 20px;
            }
            .email-login{
        text-align: end;
    }
        </style>
    @endif
    

    <style>
        body {
            background-image: url("{{ asset('web/assets/imgs/bg.png') }}");
            background-size: cover;
            
        }
        .header-style-1{
            padding-bottom: 5px !important
        }
        .content-auth{
            height: 100vh;
        }

        .form-group input{
            background-color: #fff;
            border: none;
            border-bottom: #908E98 1px solid;
        }

        .form-group input:focus{
            background-color: #fff !important;
            border: none;
            border-bottom: #908E98 1px solid;
        }

        

        .forgot-btn{
            color:#782569;
        }
        .btn-login{
            background-color: #782569;
            color: #fff;
        }
        .btn-register{
            background-color: #D6AE3E;
            color: #fff;
        }
        
        .forgot-btn{
    /*color:#782569;*/
        color: #000000;
    font-weight: bold;
    text-decoration: underline;
    
}
 .span-error-validation {
            text-align: start;
            font-weight: 500;

        }
        .content-auth{
                height: unset !important;
        }
        
    </style>
@endsection
@section('content')
    <div class=" container content-auth d-flex justify-content-center">
        <div class="row w-100 align-self-center">
            <div class="col col-12 col-md-6 p-2 p-md-5 align-self-center text-center">
                <h1 class="mt-3">{{ __('lang.create_account') }}</h1>
              {{--  <x-auth-validation-errors class="mb-4 alert alert-danger" :errors="$errors" />--}}
                <form action="{{ route('register') }}" method="POST" class="singin-form m-0 p-2 m-md-5 p-md-5">
                    @csrf
                    @method('POST')

                    <div class="form-group position-relative">
                        <input type="text" class="form-control" name="user_name" placeholder="{{ __('lang.user_name') }}" minlength="3"   >
                        <i class="fa fa-user"></i>
                          <span class="text-danger d-block  span-error-validation">
                            @error('user_name')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="form-group position-relative">
                        <input type="email" class="form-control email-login" name="email" placeholder="{{ __('lang.email') }}"   >
                        <i class="fa fa-envelope"></i>
                         <span class="text-danger d-block  span-error-validation">
                            @error('email')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control" name="phone" placeholder="{{ __('lang.phone') }}" >
                        <i class="fa fa-phone"></i>
                         <span class="text-danger d-block  span-error-validation">
                            @error('phone')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>
                    <div class="form-group position-relative">
                        <input type="password" class="form-control pe-2 ps-2" name="password" placeholder="{{ __('lang.password') }}" >
                        <i class="fa fa-key"></i>
                         <span class="text-danger d-block  span-error-validation">
                            @error('password')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="form-group position-relative">
                        <input type="password" class="form-control" name="password_confirmation" placeholder="{{ __('lang.password') }}"  >
                        <i class="fa fa-check"></i>
                         <span class="text-danger d-block  span-error-validation">
                            @error('password_confirmation')
                                {{ $message }}
                            @enderror
                        </span>
                    </div>

                    <div class="d-flex align-items-center mb-4">
                        <input class="position-static opacity-100" style="width:20px; height:20px" type="checkbox" name="Terms" required>
                        <a href="{{ route('link.terms_use') }}" class="mx-2">{{ __('lang.Agree_terms') }}</a>
                    </div>

                    <div class="row">

                        <div class="col col-12 p-3">
                            {{-- <button type="submit" class="axil-btn btn-bg-primary submit-btn p-3 m-3">
                                {{ __('lang.login') }}
                            </button> --}}
                           <div class="row">
                                <div class="col-lg-6 mt-3">
                                    <button type="submit" class="btn-login axil-btn submit-btn p-3 m-0 m-md-3 ">
                                        {{ __('lang.create_account') }}
                                    </button>
                                </div>
                                <div class="col-lg-6 mt-3">
                                    <button class="btn-login axil-btn submit-btn p-3 m-0 m-md-3 ">
                                        <a href="{{ route('registerGoogl') }}"
                                            class="btn-login">{{ __('lang.login_by_google') }}
                                            <i class="bi bi-google" style="color: #fff"></i></a>
                                    </button>
                                </div>
                            </div>
                        </div>
                        <!--<div class="col col-6 p-3">-->
                        <!--    <a href="{{ route('login') }}" class="btn-register axil-btn submit-btn p-3 m-0 m-md-3 w-100">-->
                        <!--        {{ __('lang.login') }}-->
                        <!--    </a>-->
                        <!--</div>-->
                         <div class="col col-12">
                            <div class="d-flex justify-content-start mb-3">
                                <a href="{{ route('login') }}" class="forgot-btn">
                                   {{ __('lang.have_a_account') }}
                                </a>
                            </div>
                        </div>
                        
                    </div>
                </form>
            </div>
            <div class="col col-6 d-none d-md-block">
                <img class="p-5" src="{{ Request::root() . '/dashboard/images/new_login.png'}}">
            </div>
        </div>
    </div>

    @endsection

    <!-- JS
============================================ -->
    <!-- Modernizer JS -->
    @section('js')
    <script src="{{ asset('web/assets/js/vendor/modernizr.min.js') }}"></scrip>
    <!-- jQuery JS -->
    <script src="{{ asset('web/assets/js/vendor/jquery.js') }}"></script>
    <!-- Bootstrap JS -->
    <script src="{{ asset('web/assets/js/vendor/popper.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/bootstrap.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/slick.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/js.cookie.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/jquery-ui.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/jquery.countdown.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/sal.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/jquery.magnific-popup.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/isotope.pkgd.min.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/counterup.js') }}"></script>
    <script src="{{ asset('web/assets/js/vendor/waypoints.min.js') }}"></script>

    <!-- Main JS -->
    <script src="{{ asset('web/assets/js/main.js') }}"></script>
@endsection    
