<?php

namespace App\Services;

use App\Helper\Messages;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ControllersService;
use App\Http\Resources\AdResource;
use App\Http\Resources\CategoryResource;
use App\Http\Resources\ProductResource;
use App\Models\Ad;
use App\Models\Ads;
use App\Models\Categories;

use App\Models\Products;
use Illuminate\Support\Facades\Auth;
use Throwable;

class HomeService extends Controller
{
    static function index()
    {
        try {
            $ads = Ads::get();
            $categories = Categories::where('status', 1)->where('parent_id', null)->get();
            $productsNew = Products::where('status', 1)->with('reviews', 'categories', 'favorite')->withCount('reviews', 'views')->withSum('reviews', 'rate')->filter(['type' => 'NEW'])->take(10)->get();
            $productsMostBought = Products::where('status', 1)->with('reviews', 'categories', 'favorite')->withCount('reviews', 'views')->withSum('reviews', 'rate')->filter(['type' => 'MOSTBOUGHT'])->take(10)->get();
            $productsMostWatched = Products::where('status', 1)->with('reviews', 'categories', 'favorite')->withCount('reviews', 'views')->withSum('reviews', 'rate')->filter(['type' => 'MOSTWATCHED'])->take(10)->get();
            $productsMostFavourite = Products::where('status', 1)->with('reviews', 'categories', 'favorite')->withCount('reviews', 'views')->withSum('reviews', 'rate')->filter(['type' => 'MOSTFAVOURITE'])->take(10)->get();
            $data = [
                'ads' => AdResource::collection($ads),
                'categories' => CategoryResource::collection($categories),
                'productsNew' => ProductResource::collection($productsNew),
                'productsMostBought' => ProductResource::collection($productsMostBought),
                'productsMostWatched' => ProductResource::collection($productsMostWatched),
                'productsMostFavourite' => ProductResource::collection($productsMostFavourite),
            ];
            return parent::success($data, Messages::getMessage('operation accomplished successfully'));
        } catch (Throwable $e) {
            // return "Asddddd";
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }
}
