<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Categories extends Model
{

    protected $table = 'categories';
    public $timestamps = true;
    protected $fillable = array('name_en', 'name_ar', 'status', 'image','parent_id','desc_ar','desc_en');

    public static $rules = [
        'name_ar' => 'required|min:3|max:255',
        'name_en' => 'required|min:3|max:255',
        'image' => 'required|image',
    ];
    public static $rules2 = [
        'name_ar' => 'required|min:3|max:255',
        'name_en' => 'required|min:3|max:255',
        'image' => 'nullable|image',
    ];

    public function products(){
        return $this->hasMany(Products::class , 'category_id'  , 'id');
    }
    
        public function parent()
    {
        return $this->belongsTo(Categories::class, 'parent_id');
    }

    // علاقة الفئات الفرعية
    public function subcategories()
    {
        return $this->hasMany(Categories::class, 'parent_id');
    }
      protected static function booted()
    {
        static::created(function ($category) {
            // تحديث خريطة الموقع عندما يتم إنشاء منتج جديد
            app()->make('App\Http\Controllers\dashboard\SitemapController')->updateSitemap($category, 'category');
        });
    }
     public function children()
    {
        return $this->hasMany(Categories::class, 'parent_id')->with('children');
    }
      public function allChildren()
    {
        return $this->children()->with('allChildren');
    }
}
