<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;

use App\Services\WfcoClient;

class WfcoDemoController extends Controller
{
    public function oauth(WfcoClient $wfco)
    {
        $token = $wfco->oauth(); // uses WFCO_APPROVE_CODE
        return response()->json(['token' => $token]);
    }

    public function initiate(WfcoClient $wfco)
    {
        $payload = [
            "approval_code"  => "210422551",
            "invoice_number" => "116224122851332293529",
            "otp_required"   => "N",
            "item_Info" => [
                [
                    "item_code"         => "00327988811226",
                    "item_description"  => "Samsung",
                    "item_price"        => "2000",
                    "item_percentage"   => "22.2",
                    "item_down_payment" => "0",
                ],
                [
                    "item_code"         => "0032798881026",
                    "item_description"  => "Iphone",
                    "item_price"        => "3000",
                    "item_percentage"   => "22.2",
                    "item_down_payment" => "0",
                ],
            ],
        ];

        return response()->json($wfco->initiatePo($payload));
    }

    public function otp(WfcoClient $wfco)
    {
        $payload = [
            "approval_code"  => "19689501",
            "invoice_number" => "116296070056",
            "otp_Code"       => "12345",
        ];

        return response()->json($wfco->otp($payload));
    }

    public function inquire(WfcoClient $wfco)
    {
        $payload = [
            "approval_code"  => "2455111",
            "invoice_number" => "1162045880690205995995",
            "po_Number"      => "a234fdc1-9af8-4b04-8e5d-9dea1dbeca2c",
        ];

        return response()->json($wfco->inquirePo($payload));
    }

    public function delivery(WfcoClient $wfco)
    {
        $payload = [
            "approval_code"  => "210422551",
            "invoice_number" => "116224122851332293529",
            "delivery_number" => "90632351",
            "id_number"      => "2153613511",
        ];

        return response()->json($wfco->delivery($payload));
    }

    public function cancelPo(WfcoClient $wfco)
    {
        $payload = [
            "po_Number"      => 20760881,
            "invoice_number" => "116224122851332393529",
            "amount"         => 5000,
            "enquiryFlag"    => "N",
        ];

        return response()->json($wfco->cancelPo($payload));
    }

    public function cancelContract(WfcoClient $wfco)
    {
        $payload = [
            "po_Number"      => 39028927,
            "invoice_number" => "000000066902555",
            "amount"         => 4500,
            "e​nquiryFlag"    => "Y",
        ];

        return response()->json($wfco->cancelContract($payload));
    }
}
