<?php

namespace App\Http\Controllers\web;

use App\Http\Controllers\Controller;
use App\Models\Proposal;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use function Psr\Log\warning;
use App\Mail\EmailInstallment;
use App\Models\Seo;


class ProposalsController extends Controller
{
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
         $seo=Seo::where("name_page","installment")->first();
        return view('web.proposal.create',compact('seo'));
        
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $request->validate(
            [
                'city' => 'required|max:250',
                'fill_name' => 'required|max:250',
                'phone' => 'required|numeric',
                'employer' => 'required|max:250',
                'salary' => 'required|numeric|min:0',
                'job_duration' => 'nullable|max:250',
                'email' => 'nullable|max:250',
                'total_liabilities' => 'required|max:250',

                'call_date' => 'nullable|max:250',

                'nationality' => 'required|max:255',
                'age' => 'required|numeric',
                'length_of_service' => 'required|numeric',
            ],[
                'city.required' => __('lang.city_required'),
                'city.max' => __('lang.city_max'),
                'fill_name.required' => __('lang.name_required'),
                'fill_name.max' => __('lang.name_max'),
                'phone.required' => __('lang.phone_required'),
                'phone.numeric' => __('lang.phone_numeric'),
                'employer.required' => __('lang.employer_required'),
                'employer.max   ' => __('lang.employer_max'),
                'salary.required' => __('lang.salary_required'),
                'salary.max' => __('lang.salary_max'),
                'job_duration.required' => __('lang.job_duration_required'),
                'job_duration.max' => __('lang.job_duration_max'),
                'total_liabilities.required' => __('lang.total_liabilities_required'),
                'total_liabilities.max' => __('lang.total_liabilities_max'),


                'nationality.required' => __('lang.nationality_required'),
                'nationality.max' => __('lang.nationality_max'),
                'age.required' => __('lang.age_required'),
                'age.numeric' => __('lang.age_numeric'),
                'length_of_service.required' => __('lang.length_of_service_required'),
                'length_of_service.numeric' => __('lang.length_of_service_numeric'),
            ]
        );

        $data = $request->all();


        $data['agree_terms'] = $request->agree_terms == 'ON' ? 1 : 0;
        $proposal = Proposal::create($data);
        $salary = $proposal->salary * (40/100);

        if($proposal->employer == 'متقاعد' || $proposal->employer == 'غير موظف' || $salary < $proposal->total_liabilities){
             toastr()->error('نعتذر عن قبول طلبك لعدم تحقيق شروط الأهلية');
            $proposal->delete();

            return redirect()->to('ar/installment?status=fail');
        }else{
             toastr()->success(__('lang.proposal_done'));
             dd( Mail::to('alwafy0516@gmail.com')->send(new EmailInstallment($data)));
            return redirect()->to('ar/installment?status=done');
        }
    }
}
