<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use App\Models\Products;
use App\Models\Tag;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class TagController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $tags = Tag::get();
        return view("dashboard.tags.index", compact('tags'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
        return view("dashboard.tags.create");
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $request->validate([
            'name_ar' => 'required|string|unique:tags',
            'name_en' => 'required|string|unique:tags',
        ]);
        // dd($request->all());
        $t = new Tag();
        $t->name_ar = $request->name_ar;
        $t->name_en = $request->name_en;
        $t->save();

        // Tag::create(['name_ar' => $request->name_ar, 'name_en' => $request->name_en]);

        return back()->with('message', 'تمت إضافة الوسم بنجاح');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
        $tag = Tag::find($id);
        return view("dashboard.tags.edite", compact('tag'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $request->validate([
            'name_ar' => 'required|string|unique:tags',
            'name_en' => 'required|string|unique:tags',
        ]);
        $t = Tag::find($id);
        $t->name_ar = $request->name_ar;
        $t->name_en = $request->name_en;
        $t->save();
        return back()->with('message', 'تمت تعديل الوسم بنجاح');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
        $tag = Tag::find($id);
        if ($tag->is_active == 1) {
            $tag->is_active = 0;
        } else {
            $tag->is_active = 1;
        }
        $tag->save();
        return back();
    }
    public function attachTagToProduct(Request $request, Products $product)
    {
        $request->validate([
            'tag_id' => 'required|exists:tags,id',
        ]);

        $product->tags()->attach($request->tag_id);

        return response()->json(['message' => 'تم ربط الوسم بالمنتج']);
    }
    public function assignProductToTag(Request $request)
    {

        // dd($request->all());
        $tagArray = array_filter(explode(',', $request->tag_value)); // ['2', '1']


        // Loop through it
        foreach ($tagArray as $tagId) {
            DB::table("product_tag")->insert([
                'products_id' => $request->product_id,
                'tag_id' => $tagId,
            ]);
        }
        return back()->with('message', 'تمت ربط الوسم بالمنتج بنجاح');
    }
}
