<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use App\Models\Categories;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Str;

class SliderController extends Controller
{
    //
    public function index()
    {
        $sliders = Slider::with('category')->get();
        return view('dashboard.slider.index', compact('sliders'));
    }

    /**
     * Show the form for creating a new slider.
     */
    public function create()
    {
        $category=Categories::get();
        // dd($category);
        return view('dashboard.slider.create',compact('category'));
    }

    /**
     * Store a newly created slider in storage.
     */
    public function store(Request $request)
    {
        $request->validate([
            'image' => 'required|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            'url' => 'nullable|url',
            // 'category_id' => 'required|exists:categories,id',
        ]);

        $name = Str::random(12);
        $path = $request->file('image');
        $name = $name . time() . '.' . $path->getClientOriginalExtension(); 
        $path->move('dashboard/sliderimage', $name);

        Slider::create([
            'image' => $name,
            'url' => $request->url,
            'category_id' => $request->category_id,
        ]);

        return redirect()->route('slider.index')->with('success', 'Slider created successfully.');
    }

    /**
     * Show the form for editing the specified slider.
     */
    public function edit($id)
    {
        
        $slider=Slider::find($id);
        $category=Categories::where("status",1)->get();
        return view('dashboard.slider.edit', compact('slider','category'));
    }

    /**
     * Update the specified slider in storage.
     */
    public function update(Request $request,  $id)
    {

        $slider=Slider::find($id);
      
        $request->validate([
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,webp|max:2048',
            'url' => 'nullable|url',
            // 'category_id' => 'required|exists:categories,id',
        ]);
        

        if ($request->hasFile('image')) {
            $name = Str::random(12);
        $path = $request->file('image');
        $name = $name . time() . '.' . $path->getClientOriginalExtension(); 
        $path->move('dashboard/sliderimage', $name);
        $slider->image=$name;
        }


        $slider->url = $request->url;
        $slider->category_id = $request->category_id;
        $slider->save();

        return redirect()->route('slider.index')->with('success', 'Slider updated successfully.');
    }

    /**
     * Remove the specified slider from storage.
     */
    public function destroy( $id)
{
    // العثور على الشريحة
    $slider = Slider::find($id);
    
    if ($slider) {
        // التأكد من وجود الصورة
        $imagePath = asset('dashboard/sliderimage/' . $slider->image);
        dd($imagePath);
        if (file_exists($imagePath)) {
            // حذف الصورة من السيرفر
            unlink($imagePath);
        }
        
        // حذف الشريحة من قاعدة البيانات
        $slider->delete();
        
        return redirect()->route('slider.index')->with('success', 'Slider deleted successfully.');
    }

    return redirect()->route('dashboard.slider.index')->with('error', 'Slider not found.');
}

    public function active($id)
    {
        $message="";
        $slider=Slider::find($id);
        if($slider->is_active==1)
        {
         $slider->is_active=0;
        
        }
        
        else
        {
         $slider->is_active=1;
        }
       
         if( $slider->save())
         {
            return redirect()->route('slider.index')->with('success', "تم بنجاح");
         }
         else
         {
            return redirect()->route('slider.index')->with('success', "فشل عملية التفعيل او اللغاء التفعيل");
         }
    }
}
