<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use App\Models\Address;
use App\Models\Order;
use App\Models\Shippingoptions;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class OrdersController extends Controller
{
//     public function index(Request $request)
//     {
//         $orders = Order::query()->with(['user', 'products', 'addresses.cities.countries'])->orderBy('id' , 'desc')
// //            ->when($request->user_name, function ($q) use ($request) {
// //                $q->whereHas('user' , function ($query) use ($request){
// //                    $query->where('user_name', $request->user_name);
// //                });
// //            })
//             ->get();

//         if ( $request->ajax() ) {
//             return view('dashboard.orders.table-data', compact('orders'))->render();
//         }
//         return view('dashboard.orders.index', compact('orders'));
//     }
//     public function print($id){
//         $orders = Order::where('number' , $id)->with('user', 'products', 'addresses.cities.countries')->first();
// //        return $orders;
//         return view('dashboard.orders.PrintOrder' , compact('orders'));
//     }

 public function index(Request $request)
    {
        $query = Order::query()
            ->with(['user', 'products', 'addresses.cities.countries'])
            ->orderBy('id', 'desc');

        // فلترة حسب التاريخ (من - إلى)
        if ($request->filled('from') && $request->filled('to')) {
            $query->whereBetween('created_at', [
                $request->from . ' 00:00:00',
                $request->to . ' 23:59:59'
            ]);
        }

        // فلترة حسب حالة الدفع
        if ($request->filled('payment_status')) {
            $query->where('payment_status', $request->payment_status);
        }

        $orders = $query->get();

        if ($request->ajax()) {
            return view('dashboard.orders.table-data', compact('orders'))->render();
        }

        return view('dashboard.orders.index', compact('orders'));
    }



}
