<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use App\Models\Post;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use App\Models\FAQ;
class ManagmentBlogController extends Controller
{
    //

    public function index()
    {
        $posts=Post::get();
        return view('dashboard.blog.index', compact('posts'));
    }

    public function create()
    {
        return view('dashboard.blog.create');
    }
    public function store(Request $request)
    {
        $request->validate([
            'title_ar' => 'required|string|max:255',
            'content_ar' => 'required|string',
            'title_en' => 'required|string|max:255',
            // 'content_en' => 'required|string',
            'image' => 'required|image|max:2048',
        ]);

        $name = Str::random(12);
        $path = $request->file('image');
    
        // Append the current timestamp and original file extension to the name
        $name = $name . time() . '.' . $path->getClientOriginalExtension();
    
        // Move the file to the 'dashboard/images' directory
        
        $path->move('dashboard/images', $name);
    
        // Save the file path in the database or perform other operations
        $data = $request->all();
        $data['image'] = $name;
        $post=Post::create($data);
        if (!empty($request->questions)) {
        foreach ($request->questions as $questionData) {
           FAQ::create([
                'question' => $questionData['question'],
                'answer' => $questionData['answer'],
                'post_id' => $post->id
            ]);
        }
        }

        return redirect()->route('blogAdmin.index')->with('success', 'Post created successfully!');
    }

    // Show the form to edit an existing post
    public function edit($id)
    {
        $post = Post::findOrFail($id);
         $fqas=FAQ::where('post_id',$id)->get();
        return view('dashboard.blog.edit', compact('post','fqas'));
        
    }

    // Update an existing post
    public function update(Request $request, $id)
    {
        $request->validate([
            'title_ar' => 'required|string|max:255',
            'content_ar' => 'required|string',
            'title_en' => 'required|string|max:255',
            // 'content_en' => 'required|string',
            // 'image' => 'nullable|image|max:2048',
        ]);

        $post = Post::findOrFail($id);
        $imagePath = $post->image;

        if ($request->hasFile('image')) {
            // $imagePath = $request->file('image')->store('posts', 'public');
            
                   $name = Str::random(12);
        $path = $request->file('image');
    
        // Append the current timestamp and original file extension to the name
        $name = $name . time() . '.' . $path->getClientOriginalExtension();
    
        // Move the file to the 'dashboard/images' directory
          
        $path->move('dashboard/images', $name);
       
         $post['image'] = $name;
         $post->save();
        }

        $post->update([
            'title_ar' => $request->title_ar,
            'content_ar' => $request->content_ar,
            'title_en' => $request->title_en,
            'content_en' => $request->content_en,
            // 'image' => $imagePath,
            'meta_title_ar'=>$request->meta_title_ar,
             'meta_title_en'=>$request->meta_title_en,
             'meta_desc_ar'=>$request->meta_desc_ar,
             'meta_desc_en'=>$request->meta_desc_en,
             'canonical_url_en'=>$request->canonical_url_en,
              'canonical_url_ar'=>$request->canonical_url_ar,
              'slug_ar'=>$request->slug_ar,
              'slug_en'=>$request->slug_en,
        ]);
           if ($request->has('questions')) {
         foreach ($request->questions as $id => $questionData) {
            $faq = FAQ::findOrFail($id);
            $faq->update([
                'question' => $questionData['question'],
                'answer' => $questionData['answer'],
            ]);
        }
         }
        if ($request->has('new_questions')) {
            foreach ($request->new_questions as $questionData) {
                FAQ::create([
                    'question' => $questionData['question'],
                    'answer' => $questionData['answer'],
                    'post_id'=> $id
                ]);
            }
        }

        return redirect()->route('blogAdmin.index')->with('success', 'Post updated successfully!');
    }
    
     public function active($id)
    {
        $post = Post::findOrFail($id);
        if($post->is_active==1)
        {
            $post->is_active=0;
        }
        else{
            $post->is_active=1;
        }
        $post->save();
        return redirect()->route('blogAdmin.index')->with('success', 'Post updated successfully!');

    }

    // Destroy a post
    public function destroy($id)
    {
        $post = Post::findOrFail($id);
        $post->delete();

        return redirect()->route('blogAdmin.index')->with('success', 'Post deleted successfully!');
    }
}
