<?php

namespace App\Http\Controllers\dashboard;

use App\Http\Controllers\Controller;
use App\Models\Branch;
use Illuminate\Http\Request;

class BranchController extends Controller
{
    //

    public function index()
    {
        $branches = Branch::all();
        return view('dashboard.branch.index', compact('branches'));
    }

    // إنشاء فرع جديد
    public function store(Request $request)
    {
        $request->validate([
            'phone' => 'nullable|string',
            'google_link' => 'nullable|url',
            'location' => 'nullable|string',
            'is_active' => 'nullable|boolean',
            'working_hours' => 'nullable|string',
        ]);

        $branch = Branch::create($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Branch created successfully',
            'data' => $branch
        ]);
    }

    // عرض فرع معين
    public function show($id)
    {
        $branch = Branch::findOrFail($id);

        return response()->json([
            'status' => true,
            'message' => 'Branch details',
            'data' => $branch
        ]);
    }

    // تعديل فرع
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $branch = Branch::findOrFail($id);



        $branch->update($request->all());

        return response()->json([
            'status' => true,
            'message' => 'Branch updated successfully',
            'data' => $branch
        ]);
    }

    // حذف فرع
    public function destroy($id)
    {
        $branch = Branch::findOrFail($id);
        $branch->delete();

        return response()->json([
            'status' => true,
            'message' => 'Branch deleted successfully'
        ]);
    }
    public function create()
    {
        return view('dashboard.branch.create');
    }
    public function edite($id)
    {
        $branch = Branch::find($id);
        // dd($branch);
        return view('dashboard.branch.edit', compact('branch'));
    }

    public function active($id)
    {
        $message = "";
        $slider = Branch::find($id);
        if ($slider->is_active == 1) {
            $slider->is_active = 0;
        } else {
            $slider->is_active = 1;
        }

        if ($slider->save()) {
            return redirect()->route('branches.index')->with('success', "تم بنجاح");
        } else {
            return redirect()->route('branches.index')->with('success', "فشل عملية التفعيل او اللغاء التفعيل");
        }
    }
}
