<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Mail\SendOtpMail;
use App\Models\Carts;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use App\Repositories\Cart\CartRepository;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use Illuminate\Validation\Rules;
use Illuminate\Support\Str;


class RegisteredUserController extends Controller
{
    /**
     * Display the registration view.
     *
     * @return \Illuminate\View\View
     */
    public function create()
    {
        return view('auth.register');
    }

    /**
     * Handle an incoming registration request.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\RedirectResponse
     *
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request, CartRepository $cart)
    {

        // dd("store");
        $request->validate([
            'user_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'phone' => ['required', 'string', 'max:16'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
        ]);
        
        // إنشاء المستخدم
        if (str_contains($request->email, 'tabby')) {
            $user = User::create([
                'user_name' => $request->user_name,
                'email' => $request->email,
                'phone' => $request->phone,
                'password' => Hash::make($request->password),
                'status' => 1, // المستخدم غير نشط في البداية

            ]);
            $user->save();
            Auth::login($user);
            // إعادة التوجيه إلى الصفحة السابقة
            return redirect()->back();
        }
        $user = User::create([
            'user_name' => $request->user_name,
            'email' => $request->email,
            'phone' => $request->phone,
            'password' => Hash::make($request->password),
            'status' => 0, // المستخدم غير نشط في البداية
            'referral_code' => strtoupper(Str::random(8)),
            'referred_by' => session('referral')
        ]);
        
        // توليد رمز التحقق (OTP)
        $otp = rand(100000, 999999);
        $user->otp_code = $otp; // حفظ رمز التحقق
        $user->save();
        
          try {
             Mail::to($user->email)->send(new SendOtpMail($otp));
            
        } catch (\Exception $e) {
            return back()->with('error', 'حدث خطأ أثناء إرسال البريد الإلكتروني، يرجى المحاولة مرة أخرى');
        }
        
        // إرسال الرمز عبر البريد الإلكتروني
      
        session()->put('otp_email', $user->email);
        // إعادة التوجيه إلى صفحة التحقق
        return redirect()->route('verify.otp');
      
    }
    public function showVerifyOtp()
    {
        return view('auth.verify-otp');
    }

    public function verifyOtp(Request $request , CartRepository $cart)
{
    $request->validate(['otp' => 'required|digits:6']);

    $user = User::where('email', session()->get('otp_email'))->first();
    // dd(session()->get('otp_email'));

    if ($user && $user->otp_code == $request->otp) {
        $user->status = 1; // تنشيط المستخدم
        $user->otp_code = null; // إزالة رمز التحقق
        $user->save();

        Auth::login($user);

           
        $carts = Carts::query()->with('product')
        ->where('cookie_id', $cart->getCookieId())->whereNull('user_id')->get();

    $coupon_exists = Carts::query()->with('product', 'coupon')
        ->where('cookie_id', $cart->getCookieId())->whereNull('user_id')->first();

    $total = (float)Carts::where('user_id', Auth::id())
        ->join('products', 'products.id', '=', 'carts.product_id')
        ->selectRaw('SUM(products.price * carts.quantity) as total')
        ->value('total');

    if ($coupon_exists) {
        if ($coupon_exists->coupon) {
            $discount = $total * ($coupon_exists->coupon->discount / 100);
        } else {
            $discount = 0;
        }
    } else {
        $discount = 0;
    }

    $total = $total - $discount;

    if ($carts->count() > 0) {
        foreach ($carts as $cart) {
            if ($coupon_exists) {
                $cart->update([
                    'user_id' => Auth::user()->id,
                    'coupon_id' => $coupon_exists->coupon_id,
                    'total' => $total
                ]);
            } else {
                $cart->update([
                    'user_id' => Auth::user()->id,
                ]);
            }

        }
    }




        return redirect(RouteServiceProvider::HOME);
        
    }

    return back()->withErrors(['otp' => 'رمز التحقق غير صحيح.']);
}

public function resend_otp()
{
    $user = User::where('email', session()->get('otp_email'))->first();
    if($user)
    {
    $otp = rand(100000, 999999);
    $user->otp_code = $otp; // حفظ رمز التحقق
    $user->save();
    
    // إرسال الرمز عبر البريد الإلكتروني
    Mail::to($user->email)->send(new SendOtpMail($otp));
    // return back();
     return response()->json("ok");
    }

}
}
