<?php

namespace App\Http\Controllers\auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Laravel\Socialite\Facades\Socialite;
use Illuminate\Support\Str;

class GoogleController extends Controller
{
    //

    public function registerGoogl()
    {
        return Socialite::driver('google')->with(['prompt' => 'select_account'])->redirect();
    }
    public function callbackGoogle()
    {
         
        try {
            
            $googleUser = Socialite::driver('google')->stateless()->user();
            // dd($googleUser);

            $user = User::where('email', $googleUser->email)->first();

            if ($user) {
                // المستخدم موجود: تحديث social_id فقط
                $user->update([
                    'socail_id' => $googleUser->id,
                ]);
                 Auth::login($user);
                return redirect()->route('home')->with('success',"تم تسجيل الدخول بنجاح");
            } else {
                // مستخدم جديد: تسجيل جديد
                $user = User::create([
                    'user_name'       => $googleUser->name,
                    'first_name'=> $googleUser->user['given_name'] ,
                     "status"=>1,
                     'last_name'=> $googleUser->user['family_name'] ,
                    'email'      => $googleUser->email,
                    'social_id'  =>$googleUser->user['id'],
                  
                    'password'   => bcrypt(Str::random(16)), // كلمة مرور عشوائية
                ]);
                $user->socail_id=$googleUser->user['id'];
                 $user->type_socail="google";
                  $user->email_verified_at=now();
                 $user->save();
                // dd($googleUser,$user);
                 Auth::login($user);
                 return redirect()->route('home')->with('success',"تم  انشاء الحساب  بنجاح");
            }

           

            // return redirect()->route('home'); // أو أي صفحة رئيسية
        } catch (\Exception $e) {
            return redirect()->route('login')->with('error', 'حدث خطأ أثناء تسجيل الدخول');
        }
    }
}
