<?php

namespace App\Http\Controllers\API\V1;

use App\Services\HomeService;
use App\Http\Controllers\Controller;
use App\Helper\Messages;
use App\Models\Categories;
use App\Models\Products;
use App\Models\Slider;

class HomeController extends Controller
{   
    public function getAllCategoryIds($category)
    {
        $ids = [];

        foreach ($category->children as $child) {
            $ids[] = $child->id;
            if ($child->children->count()) {
                $ids = array_merge($ids, $this->getAllCategoryIds($child));
            }
        }

        return $ids;
    }
    
    public function getMainCategoryProducts()
    {
        $mainCategories = Categories::where('is_main', 1)->where('status', 1)->with('allChildren')->get();

        $sections = [];

        foreach ($mainCategories as $main) {
            // جلب كل الأصناف الفرعية اللي تحت الصنف الرئيسي
            $allCategoryIds = $this->getAllCategoryIds($main);

            // جلب المنتجات المرتبطة بهذه الأصناف
            $products = Products::whereIn('category_id', $allCategoryIds)
                ->orderBy('price', 'desc')
                ->take(4)
                ->get();

            if ($products->count()) {
                $sections[] = [
                    'category_name' => $main?->name_ar,
                    'category' => $main,
                    'products' => $products,
                ];
            }
        }

        return $sections;
    }

    public function index()
    {


        // return "asd";
        // return HomeService::index();
          $categories = Categories::where('status', 1)->where('parent_id', null)->get();
           $slider = Slider::whereNull('category_id')->where("is_active", 1)->orderBy('id')->get();
          $sections = $this->getMainCategoryProducts();
          $data["categories"]=$categories;
          $data["projects"]=$sections;
          $data["slider"]=$slider;
        return parent::success($data, Messages::getMessage('operation accomplished successfully'));
    }
}
