<?php

namespace App\Services;

use App\Helper\Messages as HelperMessages;
use App\Helpers\Messages;
use App\Http\Controllers\Controller;
use App\Http\Controllers\ControllersService;
use App\Http\Resources\ProductResource;

use App\Models\Products;
use App\Models\ProductView;
use App\Models\Review;
use App\Models\Variant;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Throwable;

class ProductService extends Controller
{
    static function index($data)
    {
        try {
            $products = Products::select('products.*')->selectRaw(
                // 'products.*,
                // categories.title_ar as category_name,
                // attributes.title_ar as attributes_title_ar,
                // attributes.title_en as attributes_title_en,
                // options.title_ar as options_title_ar,
                // options.title_ar as options_title_en,
                // product_attributes.attribute_id,
                // product_attributes.option_id,
                '(select count(*) from favorite where favorite.product_id = products.id and favorite.user_id = ?) as is_favorite,
                (select count(*) from reviews where reviews.product_id = products.id and reviews.user_id = ?) as is_review',
                [
                    Auth::id(),
                    Auth::id()
                ]
            )
                // ->join('categories', 'categories.id', '=',  'products.category_id')
                // ->leftJoin('product_attributes', 'product_attributes.product_id', '=',  'products.id')
                // ->leftJoin('attributes', 'attributes.id', '=',  'product_attributes.attribute_id')
                // ->leftJoin('options', 'options.id', '=',  'product_attributes.option_id')
                ->with('categories')
                ->withCount('reviews')
                ->withAvg('reviews', 'rate')
                ->filter([
                    'name' => $data['name'] ?? NULL,
                    'type' => $data['type'] ?? NULL,
                    'from' => $data['form'] ?? NULL,
                    'to' => $data['to'] ?? NULL,
                    'category' => $data['category'] ?? NULL,
                    'myFavorite' => $data['myFavorite'] ?? NULL
                ])->where('products.status', 1)
                ->paginate(6);
            return $products;
            $current = 0;
            $result = [];
            foreach ($products as $product) {
                if ($current != 0 && $current != $product->id) {
                    $result[$current]['attributes'] = array_values($result[$current]['attributes']);
                }
                $current = $product->id;
                if (!isset($data[(int) $product->id])) {
                    $result[(int)$product->id] = [
                        'id' => $product->id,
                        'category_id' => $product->category_id,
                        'title_ar' => $product->title_ar,
                        'title_en' => $product->title_en,
                        'master_image' => $product->master_image,
                        'description_ar' => $product->description_ar,
                        'description_en' => $product->description_en,
                        'price' => $product->price,
                        'discount' => $product->discount,
                        'general_info_ar' => $product->general_info_ar,
                        'general_info_en' => $product->general_info_en,
                        'specefications_ar' => $product->specefications_ar,
                        'specefications_en' => $product->specefications_en,
                        'status' => $product->status,
                        'type' => $product->type,
                        'reviews_count' => $product->reviews_count,
                        'reviews_sum_rate' => $product->reviews_sum_rate,
                        'is_favorite' => $product->is_favorite,
                        'is_review' => $product->is_review,
                        'reviews_id' => $product->reviews_id,
                    ];
                }
                if (!isset($result[(int)$product->id]['attributes'][(int)$product->attribute_id])) {
                    $result[(int)$product->id]['attributes'][(int)$product->attribute_id] = [
                        'attribute_id' => $product->attribute_id,
                        'title_ar' => $product->attributes_title_ar,
                        'title_en' => $product->attributes_title_en,
                    ];
                }
                $result[(int)$product->id]['attributes'][(int)$product->attribute_id]['options'][] = [
                    'option_id' => $product->option_id,
                    'title_ar' => $product->options_title_ar,
                    'title_en' => $product->options_title_en,
                ];
            }
            if ($result) {
                $result[$current]['attributes'] = array_values($result[$current]['attributes']);
            }
            return parent::success(array_values($result),  HelperMessages::getMessage('operation accomplished successfully'));
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function show($id)
    {
        try {

            $product = Products::where("id", $id)->with(["specifications", "categories"])->first();
            $related_product = Products::where("category_id", $product->category_id)->orderBy("price", 'desc')->limit(4)->get();
            return parent::success(["product" => $product, "related_product" => $related_product],  HelperMessages::getMessage('operation accomplished successfully'));
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }


    static function reviewProduct($data)
    {
        DB::beginTransaction();
        try {
            $review = Review::where(['user_id' => auth()->id(), 'product_id' => $data->product_id]);
            if ($review) {
                return ControllersService::generateProcessResponse(true, 'CREATE_SUCCESS', 200);
            }
            Review::create([
                'user_id' => auth()->id(),
                'product_id' => $data->product_id,
                'rate' => $data->rate,
            ]);
            DB::commit();
            return ControllersService::generateProcessResponse(true, 'CREATE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function viewProduct($id)
    {
        DB::beginTransaction();
        try {
            $product = ProductView::where(['product_id' => $id, 'user_id' => auth()->user()->id])->orderBy('updated_at', 'DESC')->first();
            if ($product && $product->updated_at->addHour(3)->timestamp >= now()->timestamp) {
                return ControllersService::generateProcessResponse(false, 'exam_fail', 200);
            }
            ProductView::create([
                'user_id' => auth()->user()->id,
                'product_id' => $id,
            ]);
            DB::commit();
            return ControllersService::generateProcessResponse(true, 'CREATE_SUCCESS', 200);
        } catch (Throwable $e) {
            DB::rollBack();
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }


    static function similarProduct($id)
    {
        try {
            $products = Products::where('id', '!=', $id)->where('category_id', $id)->orderBy('price', 'desc')->paginate(5);
            return ProductResource::collection($products)
                ->additional(['code' => 200, 'status' => true, 'message' =>  HelperMessages::getMessage('operation accomplished successfully')]);
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }

    static function getVariant($data)
    {
        try {
            $variant = Variant::select('variants.*')->where('product_id', $data['product_id']);
            foreach ($data['options'] as $i => $option_id) {
                $variant->join("variant_attributes as v{$i}", "v{$i}.variant_id", '=', 'variants.id')
                    ->where("v{$i}.option_id", '=', $option_id);
            }
            if ($variant->first()) {
                return parent::success($variant->first(),  Messages::getMessage('operation accomplished successfully'));
            }
            return ControllersService::generateProcessResponse(false, 'NOT_FOUND', 200);
        } catch (Throwable $e) {
            return ControllersService::generateResponseThrowable(['message' => $e->getMessage()], 500);
        }
    }
}


// SELECT * FROM variants
// inner join `variant_attributes` as v1 on v1.variant_id = variants.id
// INNER join `variant_attributes` as v2 on v2.variant_id = variants.id
// -- inner join `variant_attributes` as v3 on v3.variant_id = variants.id
// WHERE v1.option_id = 1
// and v2.option_id = 7
// -- and v3.option_id = ?
// and variants.product_id = 2

// $query = Variant::query()->where('product_id', $request->product_id);
// foreach ($request->input('options') as $i => $option_id) {
//     $query->join("variant_attributes as v{$i}", "v{$i}.variant_id", '=', 'variants.id')
//         ->where("v{$i}.option_id", '=', $option_id);
// }

// $variant = $query->first();



// SELECT * FROM product_attributes a1
// cross join product_attributes a2 on a2.product_id = a1.product_id and a2.attribute_id <> a1.attribute_id
// cross join product_attributes a3 on a3.product_id = a1.product_id and a3.attribute_id <> a1.attribute_id and a3.attribute_id <> a2.attribute_id
// WHERE a1.product_id = 2;


// SELECT
//     a1.attribute_id attribute1,
//     a1_options.option_id AS option1,
//     a2.attribute_id AS attribute2,
//     a2_options.option_id AS option2,
//     a3.attribute_id AS attribute3,
//     a3_options.option_id AS option3
// FROM
//     (SELECT DISTINCT attribute_id FROM product_attributes) a1
// CROSS JOIN
//     (SELECT DISTINCT option_id FROM product_attributes) a1_options
// JOIN
//     (SELECT DISTINCT attribute_id FROM product_attributes) a2
// CROSS JOIN
//     (SELECT DISTINCT option_id FROM product_attributes) a2_options
// JOIN
//     (SELECT DISTINCT attribute_id FROM product_attributes) a3
// CROSS JOIN
//     (SELECT DISTINCT option_id FROM product_attributes) a3_options
// ORDER BY
//     attribute1, attribute2, attribute3;
